% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_all_tests.R
\name{compute_all_tests}
\alias{compute_all_tests}
\title{Testing pathway risk association}
\usage{
compute_all_tests(
  data,
  ind_gene = 7:ncol(data),
  num_perts = 1000,
  Ws = NULL,
  rho = NA,
  kernel = c("linear", "gaussian", "poly"),
  d = 2,
  pca_thres = 0.9,
  get_ptb_pvals = FALSE,
  ...
)
}
\arguments{
\item{data}{a \code{data.frame} of \code{N} rows and set up as the output from \code{\link{sim_SCR_data}} with columns:\itemize{
\item{\code{XR}: time to recurrence / death / censoring}
\item{\code{XD}: time to death / censoring}
\item{\code{DeltaR}: indicator of censoring (0), recurrence (1), or death (2) for this earliest time \code{XR}}
\item{\code{DeltaD}: indicator of censoring (0) or death (1)}
\item{\code{XPFS}: time to recurrence / death / censoring (=\code{XR})}
\item{\code{DeltaPFS}: indicator of censoring (0) or recurrence or death, whichever came first (1)}
\item{\code{Z_1,...,Z_P}: genomic variables}
}}

\item{ind_gene}{columns indices of genes in the pathway of interest. Default is \code{7:ncol(data)}).}

\item{num_perts}{number of perturbations used. Default is \code{1000}.}

\item{Ws}{optional inputed perturbations, should be a vector of length \code{N x num_perts} containing
i.i.d. realization of a random variable with mean=0 and variance=1.}

\item{rho}{a vector of rhos, such as one found created from the range returned by \code{\link{findRhoInterval}},
used for tuning non-linear kernel. Only used if \code{kernel} is not \code{"linear"}. Default is \code{NA}.
Currently not available for use by user-defined kernels.}

\item{kernel}{a character string indicating which kernel is used. Possible values (currently implemented) are
\code{"linear"}, \code{"gaussian"} or \code{"poly"}. Otherwise, this can also be a user defined kernel function.
See \code{\link{genericKernelEval}}.}

\item{d}{if \code{kernel} is \code{"poly"}, the polynomial power. Default is 2 (quadratic kernel).}

\item{pca_thres}{a number between \code{0} and \code{1} giving the threshold to be used for PCA.
Default is \code{0.9}. If \code{NULL}, no PCA is performed.}

\item{get_ptb_pvals}{a logical flag indicating whether perturbed p-values should be returned
as part of the results. Default is \code{FALSE}.}

\item{...}{extra parameters to be passed to a user-defined kernel.}
}
\value{
either a \code{vector} of p-values for 5 different models with names:
\item{\code{"SCR"}:}{ Semi-Competing Risks}
\item{\code{"PFS"}:}{ Progression Free Survival}
\item{\code{"CR"}:}{ Competing Risks}
\item{\code{"OS"}:}{ Overall Survival}
\item{\code{"SCR_alt"}:}{ SCR allowing different tuning parameters for the two event time processes}
or else if \code{get_ptb_pvals} is \code{TRUE}, a \code{list} with 2 elements:
\item{\code{"obs_pvals"}:}{ a vector containing the observed p-values for each of the 5 models as described above}
\item{\code{"null_pvals_perts"}:}{ a matrix of dimensions \code{num_perts x 5} containing the corresponding
perturbed p-values}
}
\description{
This functions computes p-values \code{frm} score tests of genetic pathway risk association in 5 different models
}
\examples{

## First generate some Data
feat_m_fun <- function(X){
 sin(X[,1]+X[,2]^2)-1
}
feat_d_fun <-  function(X){
 (X[,4]-X[,5])^2/8
}
mydata <- sim_SCR_data(data_size = 400, ncol_gene_mat = 20, feat_m = feat_m_fun,
                      feat_d = feat_d_fun, mu_cen = 40, cov=0.5)

#initial range
ind_gene <- c(7:ncol(mydata))
my_rho_init <- seq(0.01, 20, length=300)*length(ind_gene)
range(my_rho_init)

if(interactive()){
# compute the interval for rho
rho_set <- findRhoInterval(tZ=t(mydata[,ind_gene]), rho_init = my_rho_init, kernel="gaussian")
rho_set
range(my_rho_init) # good to check that the interval produced here is strictly contained in rho_init
# otherwise, expand rho.init and rerun

rhos <- exp(seq(log(rho_set[1]),log(rho_set[2]), length=50))

# run the tests with Gaussian kernel
compute_all_tests(data = mydata, num_perts=1000, rho=rhos, kernel="gaussian")
# run the tests with linear kernel
compute_all_tests(data=mydata, num_perts=1000, kernel="linear")
}

}
\references{
Neykov M, Hejblum BP, Sinnot JA, Kernel Machine Score Test for Pathway Analysis in the
Presence of Semi-Competing Risks, submitted, 2016.
}
