#' Returns cosine cosimilarity matrix for the terms generated by keyclust
#'
#' @description A function that extracts the cosimilarity matrix for
#' terms generated by [keyclust()]
#' @param x output from [keyclust()]
#' @keywords keyclust
#' @export
#' @return An N x N matrix of cosine cosimilarity values, where n is the number of terms in the provided embedding model
cosimilarity_matrix <- function(x) {
    UseMethod("cosimilarity_matrix")
}

#' @export
cosimilarity_matrix.keyclust <- function(x) {
    return(x$Cosim_mat)
}

