% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyplayer.R
\name{fragment}
\alias{fragment}
\title{Compute the Fragmentation Centrality Score in a Netwrok}
\usage{
fragment(
  adj.matrix,
  nodes,
  M = Inf,
  binary = FALSE,
  large = TRUE,
  geodist.precomp = NULL
)
}
\arguments{
\item{adj.matrix}{Matrix indicating the adjacency matrix of the network.}

\item{nodes}{Integer indicating the column index of the chosen player
in the adjacenncy matrix. If there are multiple players,
use \code{c(index1,index2,...)}.
If not specified, scores for all nodes will be reported.}

\item{M}{Number indicating the maximum geodistance between two nodes,
above witch the two nodes are considered disconnected.
M hence defines the reachable set. The default is \code{Inf}.}

\item{binary}{Logical scalar. If \code{TRUE}, the adjacency matrix is binarized.
If \code{FALSE}, the edge values are considered. The default is \code{FALSE}.}

\item{large}{Logical scalar, whether the computation method for large network is
implemented. If \code{TRUE} (the default), the method implmented in \pkg{igraph} is
used; otherwise the method implemented in \pkg{sna} is used.}

\item{geodist.precomp}{Geodistance precomputed for the graph to be
analyzed (optional).}
}
\value{
Vector indicating fragment score(s) of the chosen player(s).
Score is normalized to [0,1].
}
\description{
\code{fragment} measures the extent of fragmentation of a network after a
set of nodes is removed from the network. The more fragmented the residual network is, the more central a node is.
}
\details{
A natural way to apply the fragmentation centrality is in the
context of counter-terrorism, as shown in Borgatti (2006).
The measure uses geodistances to compute the fragmentation level of the
residual network, and thus edge values should be properly adjusted to
distance interpretation. The fragmentation centrality is not directional
as edge values are counted aggregately at the network level.
}
\examples{
# Create a 5x5 weighted and directed adjacency matrix, where edge values
# represent the strength of tie
W <- matrix(
  c(0,1,3,0,0,
    0,0,0,4,0,
    1,1,0,2,0,
    0,0,0,0,3,
    0,2,0,0,0),
    nrow=5, ncol=5, byrow = TRUE)

# Transform the edge value to distance interpretaion
A <- W
A[W!=0] <- 1/W[W!=0]

# List the fragmentation centrality scores for every node
fragment(A)

}
\references{
An, Weihua and Yu-Hsin Liu (2016). "keyplayer: An R Package for Locating Key Players in Social Networks."
\emph{The R Journal}, 8(1): 257-268.\cr

Borgatti, Stephen P. 2006. "Identifying Sets of Key Players in a Network."
\emph{Computational, Mathematical and Organizational Theory}, 12(1):21-34.\cr

Butts, Carter T. (2014). sna: Tools for Social Network Analysis. R package
version 2.3-2. \url{https://cran.r-project.org/package=sna}\cr

Csardi, G and Nepusz, T (2006). "The igraph software package for complex network research."
InterJournal, Complex Systems 1695. \url{https://igraph.org/} \cr
}
\seealso{
\code{\link[sna]{geodist}};
\code{\link[igraph]{shortest.paths}};
\code{\link{kpcent}};
\code{\link{kpset}}
}
\author{
Weihua An \email{weihua.an@emory.edu}; Yu-Hsin Liu \email{ugeneliu@meta.com}
}
