% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{class_ckd_stages}
\alias{class_ckd_stages}
\title{Label CKD stages or ESRD outcomes.}
\usage{
class_ckd_stages(
  df,
  egfr_col = "eGFR",
  stage_col = NULL,
  combined_stage_col = NULL
)
}
\arguments{
\item{df}{Data frame input.}

\item{egfr_col}{Column name for eGFR, mL/min/1.73 m^2.}

\item{stage_col}{Output column name for detailed CKD stages.}

\item{combined_stage_col}{Output column for combined stages 3 to 5.}
}
\value{
The modified data frame with added label columns.
}
\description{
Label CKD stages or ESRD outcomes.
}
\examples{
df <- data.frame(eGFR = c(92, 58, 42, 28, 12))
class_ckd_stages(df, egfr_col = "eGFR")
}
