% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr_all_adults.R
\name{egfr.all_adults.cys}
\alias{egfr.all_adults.cys}
\title{Calculate eGFR by all cystatin-based equations for adults}
\usage{
egfr.all_adults.cys(cystatin, age, cystatin_units = "mg/L", max_age = 100)
}
\arguments{
\item{cystatin}{Numeric vector. Serum cystatin, could be expressed in "mg/L" or "nanomol/L". Units of measurement should be defined in variable cystatin_units (if not defined explicitly by user, the default value is "mg/L").}

\item{age}{Numeric vector. Age, in years.}

\item{cystatin_units}{Character string. Units in which serum cystatin is expressed. Could be one of the following: "mg/L" or "nanomol/L"}

\item{max_age}{Numeric. Maximal age suitable for the equation application, in years. By default is 100 years, but change this value in case you would like to apply equation to older persons.}
}
\value{
numeric eGFR expressed in ml/min/1.73m\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}}.
}
\description{
Calculate eGFR by all cystatin-based equations for adults
}
\details{
Calculate eGFR by all cystatin-based equations for adults available in the kidney.epi package.

References to the equations are available in single functions of the kidney.epi package.

Citation: Bikbov B. kidney.epi: Kidney-Related Functions for Clinical and Epidemiological Research. Scientific-Tools.Org, https://Scientific-Tools.Org. DOI: 10.32614/CRAN.package.kidney.epi
}
\examples{
# for a single patient
egfr.all_adults.cys (cystatin = 1.4, age = 60,
  cystatin_units = "mg/L")
# for a dataset - see vignettes for details
# egfr.all_adults.cys (cystatin = dta$cys, age = dta$age, 
#  cystatin_units = "mg/L")
}
\author{
Programming: Boris Bikbov https://www.linkedin.com/in/boris-bikbov.
}
