% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross.R
\name{cross_spectrum}
\alias{cross_spectrum}
\alias{cross_spectrum.mts}
\alias{cross_spectrum.default}
\title{Calculate the cross-spectrum of two timeseries}
\usage{
cross_spectrum(x, ...)

\method{cross_spectrum}{mts}(x, ...)

\method{cross_spectrum}{default}(
  x,
  y,
  k = 10,
  samp = 1,
  q,
  adaptive = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{numeric; timeseries}

\item{...}{additional arguments to \code{\link[psd]{pspectrum}}}

\item{y}{numeric; timeseries. if missing, assumed to be column no. 2 in \code{x}}

\item{k}{integer; the number of sine tapers, unless this is \code{NULL}; in the latter case
a Welch-based spectrum is calculated rather than a multitaper spectrum. There are distinct
advantages and disadvantages to either of these.}

\item{samp}{numeric; the sampling rate (e.g., \code{\link{deltat}}) of the data; must be the same for \code{x} and \code{y}}

\item{q}{numeric; the probability quantile [0,1] to calculate coherence significance levels; if missing, a 
pre-specified sequence is included. This is will be ignored for Welch-based spectra (see \code{k}).}

\item{adaptive}{logical; should adaptive multitaper estimation be used?}

\item{verbose}{logical; should messages be printed?}
}
\description{
Calculate the cross-spectrum of two timeseries
}
\examples{
require(stats)
require(psd)

n <- 1000
ramp <- seq_len(n)
parab <- ramp^2

set.seed(1255)
X <- ts(rnorm(n) + ramp/2)
Y <- ts(rnorm(n) + ramp/10 + parab/100)

# Calculate the multitaper cross spectrum
csd <- cross_spectrum(X, Y, k=20)

}
