% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coordinate.R
\name{Coordinate}
\alias{Coordinate}
\title{Loading, manipulating, and analyzing coordinate data.}
\description{
Loading, manipulating, and analyzing coordinate data.

Loading, manipulating, and analyzing coordinate data.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{root_path}}{A path to a directory containing coordinate files.}

\item{\code{single_len}}{Single case length e.g. damage length. Default is NULL.}

\item{\code{is_strand_sensitive}}{Coordinate strand polarity. Default is TRUE.}

\item{\code{merge_replicate}}{Merge coordinate from different replicates.
Default is TRUE.}

\item{\code{rm_dup}}{Remove duplicate entry in the coordinate table.
Default is TRUE.}

\item{\code{add_col_rep}}{If add_col_rep is TRUE, column replicate is added to
the coordinate table. Default is TRUE.}

\item{\code{paths}}{Individual coordinate files.}

\item{\code{rep_names}}{Replicate names determined from coordinate subdirectory.}

\item{\code{chr_names}}{Chromosome names determined from filenames.}

\item{\code{coor}}{Chromosome-named list of coordinate data.table.}

\item{\code{is_kmer}}{A data.table of is_kmer status. The first column is
original is_kmer status.}

\item{\code{k}}{K-mer size when is_kmer is TRUE. When is_kmer is FALSE, k is NA.}

\item{\code{ori_first_index}}{Original chromosome-separated table first index is
either starting from zero or one.}

\item{\code{load_limit}}{Maximum coordinate table loaded.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Coordinate-new}{\code{Coordinate$new()}}
\item \href{#method-Coordinate-mark_overlap}{\code{Coordinate$mark_overlap()}}
\item \href{#method-Coordinate-print}{\code{Coordinate$print()}}
\item \href{#method-Coordinate-map_sequence}{\code{Coordinate$map_sequence()}}
\item \href{#method-Coordinate-clone}{\code{Coordinate$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coordinate-new"></a>}}
\if{latex}{\out{\hypertarget{method-Coordinate-new}{}}}
\subsection{Method \code{new()}}{
Create a new Coordinate class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coordinate$new(
  root.path,
  single.len,
  is.strand.sensitive,
  merge.replicate,
  rm.dup,
  add.col.rep,
  is.kmer,
  k,
  ori.first.index,
  load.limit
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{root.path}}{A path to a directory containing either:
(1) chromosome-separated coordinate files
(assume replicates for subdirectories) OR
(2) bedfile. (assume replicates for bedfiles)}

\item{\code{single.len}}{Single case length e.g. damage length. Default is NULL}

\item{\code{is.strand.sensitive}}{A boolean whether strand polarity matters.
Default is TRUE.}

\item{\code{merge.replicate}}{Merge coordinate from different replicates.
Default is TRUE. If not merging, duplicates will give weight to the
kmer counting. If add_col_rep, merged coordinate will contain
column replicate e.g. "rep1&rep2".}

\item{\code{rm.dup}}{Remove duplicates in each replicate. Default is FALSE
Default is FALSE}

\item{\code{add.col.rep}}{Add column replicate to coordinate table.}

\item{\code{is.kmer}}{Is the coordinate refers to k-mer i.e. expanded case?
Default is FALSE.}

\item{\code{k}}{Length of k-mer if is_kmer is TRUE.}

\item{\code{ori.first.index}}{Zero- or one-based index. Default is 1.}

\item{\code{load.limit}}{Maximum coordinate data.table loaded. Default is 1.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Coordinate} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coordinate-["></a>}}
\if{latex}{\out{\hypertarget{method-Coordinate-[}{}}}
\subsection{Method \code{[()}}{
Calling coordinate table by loading on demand. Maximum load is determine
by load_limit field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coordinate$[(
  chr.name,
  state = "current",
  k,
  reload = FALSE,
  rm.other.cols = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{chr.name}}{Chromosome name. It can be a vector of chromosomes.}

\item{\code{state}}{Coordinate state: "current", "case", "kmer". The coordinate
state is changed automatically on demand. Default is "current".}

\item{\code{k}}{K-mer size. If state is "kmer", k is needed to expand the
coordinate.}

\item{\code{reload}}{Reload the coordinate table from the root.path.
Default is TRUE.}

\item{\code{rm.other.cols}}{Remove unnecessary columns for kmeRtone operation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A single or list of data.table coordinate of requested
chromosome.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coordinate-mark_overlap"></a>}}
\if{latex}{\out{\hypertarget{method-Coordinate-mark_overlap}{}}}
\subsection{Method \code{mark_overlap()}}{
Mark overlapping regions in the coordinate table. A column name
is_overlap is added.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coordinate$mark_overlap()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{chr.names}}{Chromosome names}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
New column is_overlap is added.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coordinate-print"></a>}}
\if{latex}{\out{\hypertarget{method-Coordinate-print}{}}}
\subsection{Method \code{print()}}{
Print \code{Coordinate} object parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coordinate$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Message of \code{Coordinate} object parameters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coordinate-map_sequence"></a>}}
\if{latex}{\out{\hypertarget{method-Coordinate-map_sequence}{}}}
\subsection{Method \code{map_sequence()}}{
Get corresponding sequence from the loaded coordinate.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coordinate$map_sequence(genome)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{genome}}{Genome object or vector of named chromosome sequences.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
New column seq.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coordinate-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Coordinate-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coordinate$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
