% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knnmi.R
\name{mutual_inf_cc}
\alias{mutual_inf_cc}
\title{Mutual information estimation}
\usage{
mutual_inf_cc(target, features, k = 3L)
}
\arguments{
\item{target}{input vector.}

\item{features}{input vector or matrix.}

\item{k}{Integer number of nearest neighbors. The default value is 3.}
}
\value{
Returns the estimated mutual information. The return value is a vector of size 1 if the features argument
is a vector. If the features argument is a matrix then the return value is a vector whose size matches the
number of rows in the matrix.
}
\description{
Estimate the mutual information MI(X;Y) of the target \code{X} and features \code{Y}
where \code{X} and \code{Y} are both continuous using k-nearest neighbor distances.
}
\details{
The features argument is a vector of the same size as the target vector, or a matrix whose column dimension matches
the size of the target vector.
}
\examples{

data(mutual_info_df)
set.seed(654321)
mutual_inf_cc(mutual_info_df$Yc, t(mutual_info_df$Zc_XcYc))
mutual_inf_cc(mutual_info_df$Xc, t(mutual_info_df$Zc_XcYc), k=5)



}
\references{
Alexander Kraskov, Harald Stögbauer, and Peter Grassberger. Phys. Rev. E \strong{69}, 066138 (2004).
\doi{10.1103/PhysRevE.69.066138}
}
