% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpca_igrad.R
\name{kpca_igrad}
\alias{kpca_igrad}
\title{KPCA-IG: Variables Interpretability
in Kernel PCA}

\usage{
kpca_igrad(kpca_result, dim, mean_type = "arithmetic", trim_ratio = 0.1)
}
\arguments{
\item{kpca_result}{The result of the previously obtained kernel PCA analysis.}
\item{dim}{Number of kernel principal component to use for the computation of the scores. It should be less or equal to the number of component of the kPCA.}
\item{mean_type}{Type of mean. Possible values are "arithmetic", "geometric", "harmonic", "median", or "trimmed". Default = "arithmetic"}
\item{trim_ratio}{For mean_type == "trimmed", it is the fraction (0 to 0.5) of scores to be trimmed from each end before the mean is computed for a more robust to outliers arithmetic mean computation. }
}
\value{
A data frame containing the sorted variables and their scores sorted in decreasing order.
}
\description{
KPCA-IG, kernel pca interpetable gradient. It is the fuction that gives the feature ranking,
from the most to the least relevant variable. The ranking is
obtained through the kernel’s partial derivatives computation. A score, which corresponds to the score mean among the sample points, is assigned to each input feature.
}

\references{

Briscik, M., Dillies, MA. & Déjean, S. Improvement of variables interpretability in kernel PCA. BMC Bioinformatics 24, 282 (2023). DOI: \doi{doi:10.1186/s12859-023-05404-y}
}


\examples{
\donttest{
library(WallomicsData)
library(kpcaIG)

Transcriptomics_Stems_s <- scale(Transcriptomics_Stems)

kpca_tan <-  kernelpca(as.matrix(Transcriptomics_Stems_s),
                          kernel = "tanhdot",
                          kpar = list(scale = 0.0001, offset = 0.01))

#Compute the most relevant genes based on the first two components of kpca_tan

kpca_ig_tan <- kpca_igrad(kpca_tan, dim = c(1,2))
head(kpca_ig_tan)
}
}