% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pham.R
\name{get_f_k}
\alias{get_f_k}
\title{Get the \eqn{f(K)} vector}
\usage{
get_f_k(obj)
}
\arguments{
\item{obj}{the output of \code{kselection} function.}
}
\value{
the vector of \eqn{f(K)} function.
}
\description{
Get the \eqn{f(K)} vector.
}
\examples{
# Create a data set with two clusters
dat <- matrix(c(rnorm(100, 2, .1), rnorm(100, 3, .1),
                rnorm(100, -2, .1), rnorm(100, -3, .1)), 200, 2)

# Get the f(k) vector
sol <- kselection(dat)
f_k <- get_f_k(sol)

}
\seealso{
\code{\link{num_clusters}}, \code{\link{num_clusters_all}}
}
\author{
Daniel Rodriguez
}
