% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kuzu.R
\name{kuzu_execute}
\alias{kuzu_execute}
\title{Execute a Cypher Query}
\usage{
kuzu_execute(conn, query)
}
\arguments{
\item{conn}{A Kuzu connection object, as returned by \code{kuzu_connection()}.}

\item{query}{A string containing the Cypher query to be executed.}
}
\value{
A Python object representing the query result.
}
\description{
Submits a Cypher query to the Kuzu database for execution. This function
is used for all database operations, including schema definition (DDL),
data manipulation (DML), and querying (MATCH).
}
\examples{
\donttest{
conn <- kuzu_connection(":memory:")

# Create a node table
kuzu_execute(conn, "CREATE NODE TABLE User(name STRING, age INT64,
PRIMARY KEY (name))")

# Insert data
kuzu_execute(conn, "CREATE (:User {name: 'Alice', age: 25})")

# Query data
result <- kuzu_execute(conn, "MATCH (a:User) RETURN a.name, a.age")
}
}
