% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loinc_reference_unit_v1.R
\docType{data}
\name{loinc_reference_unit_v1}
\alias{loinc_reference_unit_v1}
\title{Data for the Reference Harmonized Units for LOINC Groups}
\format{
A data frame with 33197 rows and 8 variables.
}
\usage{
data(loinc_reference_unit_v1)
}
\description{
A dataset mapping each LOINC codes to the reference harmonized unit of their LOINC group.
}
\details{
\describe{
  \item{loinc_code}{Contains 33,197 different LOINC codes.}
  \item{unit_system}{The unit system (SI or conventional) of the reference unit.}
  \item{reference_unit}{The harmonized reference unit.}
  \item{OMOP_concept_id}{The OMOP standardized concept ID for the harmonized unit, if applicable.}
  \item{mass_molar_unit}{The reference unit of another LOINC code from the same mass–molar group.}
  \item{molecular_weight}{The molecular weight of the analyte, if applicable.}
  \item{mass_molar_loinc}{The other LOINC code that shares the same mass–molar group.}
  \item{property_group_id}{The LOINC group ID that shares the same component, property, and time aspect.}
}
}
\keyword{datasets}
