% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/badge.R
\name{create_badge}
\alias{create_badge}
\title{Create badges}
\usage{
create_badge(
  data = NULL,
  path = NULL,
  filename = NULL,
  event = NULL,
  name.column = NULL,
  affiliation.column = NULL,
  lpic = NULL,
  rpic = NULL,
  keep.files = FALSE,
  template = NULL
)
}
\arguments{
\item{data}{a data frame including names and (optionally) affiliations.}

\item{path}{Character. Path to folder where the PDF file will be saved.}

\item{filename}{Character. Filename of the pdf. If NULL, default is "Badges".}

\item{event}{Character. Title of the event.}

\item{name.column}{Character. Name of the column in \code{data} storing participants' name.}

\item{affiliation.column}{Character (optional). Name of the column in \code{data}
storing participants' affiliation.}

\item{lpic}{Character (optional) Path to a PNG image to be located in the badge top-left.}

\item{rpic}{Character (optional) Path to a PNG image to be located in the badge top-right.}

\item{keep.files}{Logical. Keep the RMarkdown template and associated files
in the output folder? Default is FALSE.}

\item{template}{Character (optional) RMarkdown template to use. If not provided,
using the default template included in \code{labeleR}.}
}
\value{
A PDF file named "Badges.pdf" is saved on disk, in the folder defined
by \code{path}. If \code{keep.files = TRUE}, an RMarkdown and PNG lpic and rpic files will also
appear in the same folder.
}
\description{
Create badges (8 badges per DIN-A4 page)
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
create_badge(
  data = badges.table,
  path = "labeleR_output",
  filename = NULL,
  event = "INTERNATIONAL CONFERENCE OF MUGGLEOLOGY",
  name.column = "List",
  affiliation.column = "Affiliation",
  lpic = NULL,
  rpic = NULL)
\dontshow{\}) # examplesIf}
}
\author{
Ignacio Ramos-Gutierrez, Julia G. de Aledo, Francisco Rodriguez-Sanchez
}
