% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lama_dictionary.R
\name{as.lama_dictionary}
\alias{as.lama_dictionary}
\alias{as.lama_dictionary.list}
\alias{as.lama_dictionary.lama_dictionary}
\alias{as.lama_dictionary.default}
\alias{as.lama_dictionary.data.frame}
\title{Coerce to a \link[=new_lama_dictionary]{lama_dictionary} class object}
\usage{
as.lama_dictionary(.data, ...)

\method{as.lama_dictionary}{list}(.data, ...)

\method{as.lama_dictionary}{lama_dictionary}(.data, ...)

\method{as.lama_dictionary}{default}(.data = NULL, ...)

\method{as.lama_dictionary}{data.frame}(.data, translation, col_old,
  col_new, ordering = rep("row", length(translation)), ...)
}
\arguments{
\item{.data}{An object holding the translations. \code{.data} can be of the
following data types:
\itemize{
\item \emph{named list}: A named list object, where each list entry is a translation
(a named character vector)
\item \emph{data.frame}: A data.frame holding one or more column pairs,
where each column pair consists of
one column holding the original variable values and
a second column holding the new labels,
which should be assigned to the original values.
}}

\item{...}{Various arguments, depending on the data type of \code{.data}.}

\item{translation}{A character vector holding the names of all translations}

\item{col_old}{This argument is only used, if the argument given in \code{.data}
is a data.frame. In this case, the
argument \code{col_old} must be a character vector (same length as \code{translation}) holding the
names of the columns in the data.frame (in the argument \code{.data}) which hold
the original variable values.
These columns can be of any type: \code{character}, \code{logical}, \code{numerical} or \code{factor}.}

\item{col_new}{This argument is only used, if the argument given in \code{.data}
is a data.frame. In this case, the
argument \code{col_old} must be a character vector (same length as \code{translation}) holding the
names of the columns in the data.frame (in the argument \code{.data}) which hold
the new labels, which should be assigned to the original values.
These columns can be \code{character} vectors or \code{factors} with character labels.}

\item{ordering}{This argument is only used, if the argument given in \code{.data}
is a data.frame. In this case, the
argument \code{ordering} must be a character vector (same length as \code{translation}) holding
one of the following configuration strings configuring
the ordering of each corresponding translation:
\itemize{
\item \code{"row"}: The corresponding translation will be ordered exactly in the same
way as the rows are ordered in the data.frame \code{.data}.
\item \code{"old"}: The corresponding translation will be ordered by the given
original values which are contained in the corresponding column \code{col_old}.
If the column contains a factor variable, then the ordering of the
factor will be used. If it just contains a plain character variable,
then it will be ordered alphanumerically.
\item \code{"new"}: The corresponding translation will be ordered by the given
new labels which are contained in the corresponding column \code{col_new}.
If the column contains a factor variable, then the ordering of the
factor will be used. If it just contains a plain character variable,
then it will be ordered alphanumerically.
}}
}
\value{
A new lama_dictionary class object holding the passed in translations.
}
\description{
This function allows two types of arguments:
\itemize{
\item \emph{named list}: A named list object holding the translations.
\item \emph{data.frame}: A data.frame with one ore more column pairs. Each column
pair consists of a column holding the original values, which should be replaced,
and a second character column holding the new labels which should be
assigned to the original values. Use the arguments \code{col_old} and \code{col_new}
in order to define which columns are holding original values and which
columns hold the new labels. The names of the resulting translations
are defined by a character vector given in argument \code{translation}.
Furthermore, each translation can have a different ordering which can be
configured by a character vector given in argument \code{ordering}.
}
}
\section{Translations}{

A \emph{translation} is a \emph{named character vector} of non zero length.
This named character vector defines
which labels (of type character) should be assigned to which values
(can be of type character, logical or numeric)
(e.g. the translation \code{c("0" = "urban", "1" = "rural")} assigns the label
\code{"urban"} to the value \code{0} and \code{"rural"} to the value \code{1}, for example the
variable \code{x = c(0, 0, 1)} is translated to \code{x_new = c("urban", "urban", "rural")}).
Therefore, a translation (named character vector) contains the following information:
\itemize{
\item The \emph{names} of the character vector entries correspond to the
\emph{original variable levels}.
Variables of types \code{numeric} or \code{logical} are turned automatically into a
character vector (e.g. \code{0} and \code{1} are treated like \code{"0"} and \code{"1"}).
\item The \emph{entries} (character strings) of the character vector correspond to
the new \emph{labels}, which will be assigned to the original variable levels.
It is also allowed to have missing labels (\code{NA}s).
In this case, the original values are mapped onto missing values.
}

The function \code{\link[=lama_translate]{lama_translate()}} is used in order to apply a translation on a variable.
The resulting vector with the assigned labels can be of the following types:
\itemize{
\item \emph{character}: An unordered vector holding the new character labels.
\item \emph{factor} with character levels: An ordered vector holding the new character labels.
}

The original variable can be of the following types:
\itemize{
\item \emph{character} vector: This is the simplest case. The character values
will replaced by the corresponding labels.
\item \emph{numeric} or \emph{logical} vector: Vectors of type \emph{numeric} or \emph{logical}
will be turned
into \emph{character} vectors automatically before the translation process and
then simply processed like in the \emph{character} case.
Therefore, it is sufficient to define the translation mapping for the
\emph{character} case, since it also covers the \emph{numeric} and \emph{logical} case.
\item \emph{factor} vector with levels of any type: When translating factor variables
one can decide whether or not to keep the original ordering. Like in the
other cases the levels of the factor variable will always be turned into
character strings before the translation process.
}
}

\section{Missing values}{

It is also possible to handle missing values with \code{\link[=lama_translate]{lama_translate()}}.
Therefore, the used translation must contain a information that tells how
to handle a missing value. In order to define such a translation
the missing value (\code{NA}) can be escaped with the character string \code{"NA_"}.
This can be useful in two situations:
\itemize{
\item All missing values should be labeled
(e.g. the translation \code{c("0" = "urban", "1" = "rural", NA_ = "missing")}
assigns the character string \code{"missing"} to all missing values of a variable).
\item Map some original values to \code{NA}
(e.g. the translation \code{c("0" = "urban", "1" = "rural", "2" = "NA_", "3" = "NA_")}
assigns \code{NA} (the missing character) to the original values \code{2} and \code{3}).
Actually, in this case the translation definition does not always have to
use this escape mechanism, but only
when defining the translations inside of a \code{YAML} file,
since the \code{YAML} parser does not recognize missing values.
}
}

\section{lama_dictionary class objects}{

Each \emph{lama_dictionary} class object can contain multiple \emph{translations},
each with a unique name under which the translation can be found.
The function \code{\link[=lama_translate]{lama_translate()}} uses a lama_dictionary class object
to translate a normal \code{vector} or to translate one or more columns in a
\code{data.frame}.
Sometimes it may be necessary to have different translations
for the same variable, in this case it is best to have multiple
translations with different names
(e.g. \code{area_short = c("0" = "urb", "1" = "rur")} and
\code{area = c("0" = "urban", "1" = "rural")}).
}

\examples{
  ## Example-1: Initialize a lama-dictionary from a list oject
  ##            holding the translations
  obj <- list(
    country = c(uk = "United Kingdom", fr = "France", NA_ = "other countries"),
    language = c(en = "English", fr = "French")
  )
  dict <- as.lama_dictionary(obj)
  dict
  
  ## Example-2: Initialize a lama-dictionary from a data frame
  ##            holding the label assignment rules
  df_map <- data.frame(
    c_old = c("uk", "fr", NA),
    c_new = c("United Kingdom", "France", "other countries"),
    l_old = c("en", "fr", NA),
    l_new = factor(c("English", "French", NA), levels = c("French", "English"))
  )
  dict <- as.lama_dictionary(
    df_map,
    translation = c("country", "language"),
    col_old = c("c_old", "l_old"),
    col_new = c("c_new", "l_new"),
    ordering = c("row", "new")
  )
  # 'country' is ordered as in the 'df_map'
  # 'language' is ordered differently ("French" first)
  dict
}
