% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exampleOptim.R
\name{exampleOptimization}
\alias{exampleOptimization}
\title{Performs a complete simplex optimization over a response surface}
\usage{
exampleOptimization(surface, simplex = NULL, centroid = c(7, 340),
  stepsize = c(0.6, 10), algor = "fixed", experiments = 17, noise = 0)
}
\arguments{
\item{surface}{example response surface to be used. See
\code{\link{exampleSurfaceR2}},
\code{\link{exampleSurfaceR3}} and
\code{\link{exampleSurfaceR2.2pks}}}

\item{simplex}{object of class \code{smplx} with the simplex
information. See \code{\link{labsimplex}}}

\item{centroid}{numeric vector of size \code{n} with coordinates of the
centroid}

\item{stepsize}{numeric vector of size \code{n} with the step-sizes for
each coordinate}

\item{algor}{algorithm to be followed in the vertex generation.
\code{'fixed'} for a fixed step-size simplex
or \code{'variable'} for a variable step-size simplex}

\item{experiments}{number of vertexes to evaluate}

\item{noise}{absolute noise to be included in the results}
}
\value{
An object with class \code{smplx} with the simplex optimization
  data.
}
\description{
The function uses the information in a simplex or creates a
new one by using the defined centroid and step-size to perform a simplex
optimization using the responses produced in the example response
surfaces included in the package.
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Jesús Ágreda, \email{jagreda@unal.edu.co}
}
