% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSimplexResponse.R
\name{plotSimplexResponse}
\alias{plotSimplexResponse}
\title{Plots the response versus the vertex number of a simplex optimization.}
\usage{
plotSimplexResponse(x, ...)
}
\arguments{
\item{x}{object with class \code{smplx} containig the coordinates of
the vertices and their responses.}

\item{...}{other graphical parameters used in \code{\link[graphics]{plot}}}
}
\value{
Plot of response against vertex number.
}
\description{
The function generates a \code{ggplot} object from an object with class
\code{smplx}. The response is plotted against the vertex number.
}
\details{
If the simplex object being ploted was obtained using a variable size
algorithm, some experimental points could be disregarded and will be
shown with a red mark indicating that the vertex was not used in the
obtention of new vertexes.
}
\examples{
  simplex <- exampleOptimization(surface = exampleSurfaceR3,
                                 centroid = c(350, 11, 0.7),
                                 stepsize = c(10, 0.5, 0.1),
                                 experiments = 18, algor = 'variable')
  plotSimplexResponse(simplex)
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Jesús Ágreda, \email{jagreda@unal.edu.co}
}
