% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_forest.R
\name{factor_forest}
\alias{factor_forest}
\title{Estimate Number of Dimensions using Factor Forest}
\usage{
factor_forest(
  data,
  sample_size,
  maximum_factors = 8,
  PA_correlation = c("cor", "poly", "tet")
)
}
\arguments{
\item{data}{Matrix or data frame.
Either a dataset with all numeric values
(rows = cases, columns = variables) or
a symmetric correlation matrix}

\item{sample_size}{Numeric (length = 1).
If input into \code{data} is a correlation matrix,
then specifying the sample size is required}

\item{maximum_factors}{Numeric (length = 1).
Maximum number of factors to search over.
Defaults to \code{8}}

\item{PA_correlation}{Character (length = 1).
Type of correlation used in \code{\link[psych]{fa.parallel}}.
Must be set:

\itemize{

\item \code{"cor"} --- Pearson's correlation

\item \code{"poly"} --- Polychoric correlation

\item \code{"tet"} --- Tetrachoric correlation

}}
}
\value{
Returns a list containing:

\item{dimensions}{Number of dimensions identified}

\item{probabilities}{Probability that the number of dimensions
is most likely}
}
\description{
Estimates the number of dimensions in data using the
pre-trained Random Forest model from Goretzko and Buhner
(2020, 2022). See examples to get started
}
\examples{
# Generate factor data
two_factor <- simulate_factors(
  factors = 2, # factors = 2
  variables = 6, # variables per factor = 6
  loadings = 0.55, # loadings between = 0.45 to 0.65
  cross_loadings = 0.05, # cross-loadings N(0, 0.05)
  correlations = 0.30, # correlation between factors = 0.30
  sample_size = 1000 # number of cases = 1000
)

\dontrun{
# Perform Factor Forest
factor_forest(two_factor$data)}

}
\references{
Goretzko, D., & Buhner, M. (2022).
Factor retention using machine learning with ordinal data.
\emph{Applied Psychological Measurement}, 01466216221089345.

Goretzko, D., & Buhner, M. (2020).
One model to rule them all? Using machine learning
algorithms to determine the number of factors
in exploratory factor analysis.
\emph{Psychological Methods}, \emph{25}(6), 776-786.
}
\author{
# Authors of Factor Forest \cr
David Goretzko and Markus Buhner

# Authors of \{latentFactoR\} \cr
Alexander P. Christensen <alexpaulchristensen@gmail.com>,
Hudson Golino <hfg9s@virginia.edu>,
Luis Eduardo Garrido <luisgarrido@pucmm.edu>
}
