% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/lbaModel.R
\name{rlba_r}
\alias{rlba_r}
\alias{rlba}
\title{Simulate Choices and Response Times}
\usage{
rlba_r(
  parameter_r,
  is_positive_drift_r,
  time_parameter_r,
  n = 1L,
  use_inverse_method = FALSE,
  debug = FALSE
)

rlba(
  parameter_r,
  is_positive_drift_r,
  time_parameter_r,
  n = 1L,
  use_inverse_method = FALSE,
  debug = FALSE,
  seed = NULL
)
}
\arguments{
\item{parameter_r}{A numeric matrix of LBA parameters. Each column
corresponds to an accumulator, and each row corresponds to a parameter,
with the expected order being:
\itemize{
\item \code{A} - Starting point variability
\item \code{b} - Thresholds
\item \code{mean_v} - Mean drift rates
\item \code{sd_v} - Standard deviation drift rates
\item \code{st0} - Variability of the non-decision
\item \code{t0} - Non-decision time
}}

\item{is_positive_drift_r}{A logical vector indicating whether the
drift rate (\code{v}) is strictly positive.}

\item{time_parameter_r}{A numeric vector to set the simulated time grid,
with the expected value for: minimal and maximum decision times and the
difference time (i.e., \code{min dt}, \code{max dt} and \code{dt}).}

\item{n}{Integer. Number of trials to simulate. Defaults to \code{1L}.}

\item{use_inverse_method}{Logical. If \code{TRUE}, use the inverse
transform sampling method; otherwise use
the standard sampling method.Defaults to
\code{FALSE}. TODO: fix the memory problem.}

\item{debug}{Logical. If \code{TRUE}, prints detailed messages
for debugging. Defaults to \code{FALSE}.}

\item{seed}{Optional integer. If provided, sets the random seed for
reproducible simulation. Defaults to \code{NULL}. Available
only in the R interface.}
}
\value{
A \code{data.frame}. Each row corresponds to a simulated trial
containing:
\itemize{
\item \code{trial} — Trial index
\item \code{choice} — Index of the winning accumulator
\item \code{rt} — Simulated response time
}
}
\description{
Simulate Choices and Response Times
}
\details{
This function generates simulated data for the LBA model. The function
supports both standard and inverse transform sampling methods. The
inverse method may offer better numerical behaviour in edge cases (e.g.,
small RTs or boundary conditions).
}
\examples{
param_list2mat <- function(param_list) {
  n_row <- length(param_list[[1]])
  n_col <- length(param_list)
  out <- matrix(NA, nrow = n_row, ncol = n_col)

  for (i in seq_len(n_col)) {
    out[, i] <- param_list[[i]]
  }
  t(out)
}

A <- 1.2
b <- 2.7
t0 <- .2

mean_v <- c(2.4, 2.2)
sd_v <- c(1, 1)

RT <- seq(0, 3, .4) + t0
posdrift <- TRUE
nv <- length(mean_v)

st0 <- 0

params_tmp <- list(
  A = rep(A, nv),
  b = rep(b, nv),
  mean_v = mean_v,
  sd_v = sd_v,
  st0 = rep(st0, nv),
  t0 = rep(t0, nv)
)

params <- param_list2mat(params_tmp)
is_positive_drift <- rep(TRUE, nv)

n <- 1
seed <- 123

dt <- 0.01
min_dt <- 0
max_dt <- 5
time_parameter_r <- c(min_dt, max_dt, dt)


set.seed(seed)
# R interface
result1 <- rlba(params, is_positive_drift, time_parameter_r, n,
  seed = seed, debug = TRUE
)
# C++ interface. No seed argument.
result2 <- rlba_r(params, is_positive_drift, time_parameter_r, n,
  debug = TRUE
)

print(result1)
print(result2)

}
