% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.R
\name{print.lcc}
\alias{print.lcc}
\title{Print Method for \code{lcc} Objects}
\usage{
\method{print}{lcc}(x, digits = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{lcc}, representing a fitted longitudinal
concordance correlation model.}

\item{digits}{Minimum number of significant digits to be printed in values.
Default is \code{NULL}, which uses the default precision.}

\item{...}{Further arguments passed to \code{print}.}
}
\value{
The function is used for its side effect of printing and returns
  the input \code{lcc} object invisibly.
}
\description{
Prints detailed information about the fitted longitudinal
  concordance correlation model contained in an \code{lcc} object.
}
\examples{
\dontrun{
fm1 <- lcc(data = hue, subject = "Fruit", resp = "H_mean",
          method = "Method", time = "Time", qf = 2, qr = 2)
print(fm1)
}

}
\seealso{
\code{\link[lcc]{lcc}}, \code{\link[lcc]{summary.lcc}}
}
