% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin.R
\name{sim.bin}
\alias{sim.bin}
\title{Generate Random Sample from a DC Model}
\usage{
sim.bin(
  coef = 2L,
  nObs = 100,
  probit = FALSE,
  maxWeight = 1,
  pPos = 0.5,
  sampleFactor = 4,
  toNumeric = TRUE
)
}
\arguments{
\item{coef}{Either a single integer specifying the number of variables in the model,
or a numeric vector of coefficients for the regression.}

\item{nObs}{The number of observations to generate.}

\item{probit}{Logical value indicating whether to generate data from a probit model
(if \code{TRUE}) or a logit model (if \code{FALSE}).}

\item{maxWeight}{Integer value indicating the maximum weight of the observations.
If \code{1}, observations are not weighted.
If larger than \code{1}, a vector of weights is generated and included in the return list. The weights are drawn from a discrete uniform distribution with a maximum value determined by \code{maxWeight}.
If weighted, a larger sample is created (\code{nObs * sampleFactor * maxWeight}) and a subset of them is randomly selected, where the probability of selection is determined by the weight.}

\item{pPos}{The percentage of positive observations (\code{y=1}) in the endogenous variable y.
Must be between 0 and 1.
In the current implementation, this is independent of the weights, if \code{maxWeight} is larger than 1.}

\item{sampleFactor}{The factor used to control the size of the initial sample.
A larger value generates a larger initial sample, which can increase the accuracy
of the generated sample but also takes more time and memory.}

\item{toNumeric}{If \code{TRUE}, \code{y} and \code{w} are transformed to have numeric vector.
Otherwise, they contain an integer vector.}
}
\value{
A list with the following items:
\item{y}{The endogenous variable.}
\item{x}{The exogenous variables.}
\item{w}{The weights of the observations. It is \code{NULL} if \code{weighted} is \code{FALSE}.}
\item{p1}{Prob(Y=1)}
\item{coef}{The coefficients of the regression.}
\item{probit}{Logical value indicating whether data was generated from a probit model.}
\item{pPos}{The percentage of negative observations in y.}
}
\description{
This function generates a random sample from an discrete choice regression model.
}
\examples{
# Generate data from a logit model with 3 variables
sample <- sim.bin(3L, 100)

# see the examples in 'estim.bin' or 'search.bin' functions
}
\seealso{
\link{estim.bin}, \link{search.bin}
}
