% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-color.R
\name{makeColorMatrix}
\alias{makeColorMatrix}
\title{makeColorMatrix}
\usage{
makeColorMatrix(x, data, palette, ...)
}
\arguments{
\item{x}{Object representing the color. Can be of class integer, numeric, Date,
POSIX*, character with color names or HEX codes, factor, matrix, data.frame,
list, json or formula.}

\item{data}{The dataset}

\item{palette}{Name of a color palette. If \code{colourvalues} is installed, it is
passed to \code{\link[colourvalues]{colour_values_rgb}}. To see all available
palettes, please use \code{\link[colourvalues]{colour_palettes}}.
If \code{colourvalues} is not installed, the palette is passed to
\code{\link[leaflet]{colorNumeric}}.}

\item{...}{Passed to \code{\link[colourvalues]{colour_palettes}} or
\code{\link[leaflet]{colorNumeric}}.}
}
\description{
Transform object to rgb color matrix
}
\examples{
{
## For Integer/Numeric/Factor
makeColorMatrix(23L)
makeColorMatrix(23)
makeColorMatrix(as.factor(23))

## For POSIXt / Date
makeColorMatrix(as.POSIXlt(Sys.time(), "America/New_York"), NULL)
makeColorMatrix(Sys.time(), NULL)
makeColorMatrix(Sys.Date(), NULL)

## For matrix/data.frame
makeColorMatrix(cbind(130,1,1), NULL)
makeColorMatrix(matrix(1:99, ncol = 3, byrow = TRUE), data.frame(x=c(1:33)))
makeColorMatrix(data.frame(matrix(1:99, ncol = 3, byrow = TRUE)), data.frame(x=c(1:33)))

## For characters
testdf <- data.frame(
  texts = LETTERS[1:10],
  vals = 1:10,
  vals1 = 11:20
)
makeColorMatrix("red", testdf)
makeColorMatrix("val", testdf)

## For formulaes
makeColorMatrix(~vals, testdf)
makeColorMatrix(~vals1, testdf)

## For JSON
library(jsonify)
makeColorMatrix(jsonify::to_json(data.frame(r = 54, g = 186, b = 1)), NULL)

## For Lists
makeColorMatrix(list(1,2), data.frame(x=c(1,2)))
}
}
