% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movingmarker.R
\name{startMoving}
\alias{startMoving}
\alias{stopMoving}
\alias{pauseMoving}
\alias{resumeMoving}
\alias{addLatLngMoving}
\alias{moveToMoving}
\alias{addStationMoving}
\title{Interact with the moving markers}
\usage{
startMoving(map, layerId = NULL)

stopMoving(map, layerId = NULL)

pauseMoving(map, layerId = NULL)

resumeMoving(map, layerId = NULL)

addLatLngMoving(map, layerId = NULL, latlng, duration)

moveToMoving(map, layerId = NULL, latlng, duration)

addStationMoving(map, layerId = NULL, pointIndex, duration)
}
\arguments{
\item{map}{The leafletProxy object}

\item{layerId}{You can pass a string or a vector of strings for the moving
markers that you want to address. If none is specified, the action will be
applied to all moving markers.}

\item{latlng}{Coordinates as list (e.g.: \code{list(33, -67)} or
\code{list(lng=-65, lat=33)})}

\item{duration}{Duration in milliseconds}

\item{pointIndex}{Index of a certain point}
}
\value{
the new \code{map} object
}
\description{
The marker begins its path or resumes if it is paused.
}
\section{Functions}{
\itemize{
\item \code{stopMoving()}: Manually stops the marker, if you call \code{start}
after, the marker starts again the polyline at the beginning.

\item \code{pauseMoving()}: Pauses the marker

\item \code{resumeMoving()}: The marker resumes its animation

\item \code{addLatLngMoving()}: Adds a point to the polyline.
Useful, if we have to set the path one by one.

\item \code{moveToMoving()}: Stop the current animation and make the marker move
to \code{latlng} in \code{duration} ms.

\item \code{addStationMoving()}: The marker will stop at the \code{pointIndex} point
of the polyline for \code{duration} milliseconds. You can't add a station
at the first or last point of the polyline.

}}
\references{
\url{https://github.com/ewoken/Leaflet.MovingMarker}
}
\seealso{
Other MovingMarker Functions: 
\code{\link{addMovingMarker}()},
\code{\link{movingMarkerOptions}()}
}
\concept{MovingMarker Functions}
