% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/areaCalculator.R
\name{areaCalculator}
\alias{areaCalculator}
\title{Calculate the area of a polygon defined by latitude and longitude points}
\usage{
areaCalculator(longitude, latitude, coordinate = "WGS-84", chull = TRUE)
}
\arguments{
\item{longitude}{A numeric vector of longitude points.}

\item{latitude}{A numeric vector of latitude points.}

\item{coordinate}{A string indicating the coordinate system of the input points, can be "WGS-84",
"GCJ-02", or "BD-09". Default is "WGS-84".}

\item{chull}{A logical value indicating whether to use the convex hull of the points. Default is TRUE.}
}
\value{
A numeric value representing the area of the polygon in square meters.
}
\description{
This function takes in latitude and longitude vectors and calculates the area of the polygon
defined by those points. It can handle different coordinate systems such as WGS-84, GCJ-02, and BD-09.
}
\examples{
area <- areaCalculator(
  longitude = c(121.0, 122.1, 121.2, 122.15, 121.2),
  latitude =  c(31.1, 31.919, 31.917, 31.15, 31.12), coordinate = "WGS-84"
)
}
