% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{hist.leem}
\alias{hist.leem}
\title{Histogram graph}
\usage{
\method{hist}{leem}(
  x,
  freq = "a",
  bg = TRUE,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  grids = grid(col = "white"),
  bgcol = "gray",
  bgborder = NA,
  barcol = "yellow",
  barborder = "gray",
  ...
)
}
\arguments{
\item{x}{R object (list) of class leem. Use \code{new_leem()} function.}

\item{freq}{Character argument. Type of frequency with options: \code{"a"} (absolute and default), \code{"r"} relative and \code{"p"} percentage.}

\item{bg}{Logical argument. Default is \code{TRUE}, it displays the background, and \code{bg = FALSE} otherwise.}

\item{main}{Insert the plot title.  The default is \code{NULL}.}

\item{xlab}{Insert the title of the x-axis graphic label. The default is \code{NULL}.}

\item{ylab}{Insert the title of the y-axis graphic label. The default is \code{NULL}.}

\item{grids}{Insert grids to plot. The default is \code{grid(col = "white")}.}

\item{bgcol}{Insert the background color. This argument is only valid when \code{bg = TRUE}. The default is \code{bgcol="gray"}.}

\item{bgborder}{Insert the background border color. This argument is only valid when \code{bg = TRUE}. The default is bgborder = NA.}

\item{barcol}{Insert the barplot color. The default is \code{barcol = "yellow"}. This argument is only valid when \code{bars = TRUE}.}

\item{barborder}{Numeric argument. Insert the barplot border color. This argument is only valid when \code{bars = TRUE}. The default is barborder = "gray".}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Class method leem for generic hist
}
\examples{
# Example 1
library(leem)
rnorm(36, 100, 50) |> new_leem(variable = "continuous") |> tabfreq() |> hist()

# Example 2
library(leem)
school <- rep(c("high", "university", "basic"), 3:5)
sample(school, 30, TRUE) |>
 new_leem() |>
 tabfreq(ordered = c("basic", "high", "university"))

}
