% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsave_elsevier.R
\name{ggsave_elsevier}
\alias{ggsave_elsevier}
\title{Save a plot - Elsevier figure size}
\usage{
ggsave_elsevier(
  filename,
  plot,
  width = c("one_column", "one_half_column", "full_page"),
  height,
  ...
)
}
\arguments{
\item{filename}{A character string. File name to create on disk.}

\item{plot}{Plot to save, ggplot or other grid object.}

\item{width}{Plot width. See \strong{Details} for more information.}

\item{height}{Plot height in "mm".}

\item{...}{Passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}}
}
\value{
An image file containing the saved plot.
}
\description{
Save a plot using \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}.
Plot size follows instructions of Elsevier journals.
}
\details{
Instruction of Elsevier about \href{https://www.elsevier.com/about/policies-and-standards/author/artwork-and-media-instructions/artwork-sizing}{sizing of artwork}.
\itemize{
\item Image width:
\itemize{
\item single column: 90 mm (255 pt)
\item 1.5 column: 140 mm (397 pt)
\item double column (full width): 190 mm (539 pt)
}
\item Image height: maximum 240 mm.
}
}
\examples{

library(ggplot2)

fig <- ggplot(mtcars, aes(y = mpg, x = disp)) +
    geom_point(aes(colour = factor(cyl)))

## For demo, a temp. file path is created with the file extension .png
png_file <- tempfile(fileext = ".png")

ggsave_elsevier(png_file, plot = fig, width = "full_page", height = 120)
}
\seealso{
\code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}
}
