% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lev-distance.R
\name{lev_token_sort_ratio}
\alias{lev_token_sort_ratio}
\title{Ordered token matching}
\usage{
lev_token_sort_ratio(a, b, pairwise = TRUE, useNames = TRUE, ...)
}
\arguments{
\item{a, b}{The input strings}

\item{pairwise}{Boolean. If \code{TRUE}, only the pairwise distances between \code{a} and \code{b} will be
computed, rather than the combinations of all elements.}

\item{useNames}{Boolean. Use input vectors as row and column names?}

\item{...}{Additional arguments to be passed to \code{\link[stringdist:stringdist]{stringdist::stringdistmatrix()}} or
\code{\link[stringdist:stringsim]{stringdist::stringsimmatrix()}}.}
}
\value{
A numeric scalar, vector or matrix depending on the length of the inputs.
}
\description{
Compares strings by tokenising them, sorting the tokens alphabetically and then computing the
\code{\link[=lev_ratio]{lev_ratio()}} of the result. This means that the order of words is irrelevant which can be
helpful in some circumstances.
}
\examples{
x <- "Episode IV - Star Wars: A New Hope"
y <- "Star Wars Episode IV - New Hope"

# Because the order of words is different the simple approach gives a low match ratio.
lev_ratio(x, y)

# The sorted token approach ignores word order.
lev_token_sort_ratio(x, y)
}
\seealso{
\code{\link[=lev_token_set_ratio]{lev_token_set_ratio()}}
}
