% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineup.R
\name{lineupOutput}
\alias{lineupOutput}
\alias{renderLineup}
\title{Shiny bindings for lineup}
\usage{
lineupOutput(outputId, width = "100\%", height = "800px")

renderLineup(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'800px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a taggle}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
An output or render function that enables the use of the widget within Shiny applications.
}
\description{
Output and render functions for using lineup within Shiny
applications and interactive Rmd documents.
}
\examples{
# !formatR
library(shiny)
app <- shinyApp(
  ui = fluidPage(lineupOutput("lineup")),
  server = function(input, output) {
    lineup <- lineupBuilder(iris) |> buildLineUp()
    output$lineup <- renderLineup(lineup)
  }
)

\donttest{
if (interactive()) app
}
}
