% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{addCustomTime}
\alias{addCustomTime}
\title{Add a new vertical bar at a time point that can be dragged by the user}
\usage{
addCustomTime(id, time, itemId)
}
\arguments{
\item{id}{graph2d id or a \code{linevis} object (the output from \code{linevis()})}

\item{time}{The date/time to add}

\item{itemId}{The id of the custom time bar}
}
\value{
None, side-effect is Javascript call
}
\description{
Add a new vertical bar at a time point that can be dragged by the user
}
\examples{
\dontrun{
linevis() \%>\%
  addCustomTime(Sys.Date() - 1, "yesterday")
}

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    linevisOutput("graph2d"),
    actionButton("btn", "Add time bar 24 hours ago")
  ),
  server = function(input, output) {
    output$graph2d <- renderLinevis(
      linevis()
    )
    observeEvent(input$btn, {
      addCustomTime("graph2d", Sys.Date() - 1, "yesterday")
    })
  }
)
}
}
