% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lma_process.R
\name{lma_process}
\alias{lma_process}
\title{Process Text}
\usage{
lma_process(input = NULL, ..., meta = TRUE, coverage = FALSE)
}
\arguments{
\item{input}{A vector of text, or path to a text file or folder.}

\item{...}{arguments to be passed to \code{\link{lma_dtm}}, \code{\link{lma_patcat}}, \code{\link{lma_weight}},
\code{\link{lma_termcat}}, and/or \code{\link{lma_lspace}}. All arguments must be named.}

\item{meta}{Logical; if \code{FALSE}, metastatistics are not included. Only applies when raw text is available.
If included, meta categories are added as the last columns, with names starting with "meta_".}

\item{coverage}{Logical; if \code{TRUE} and a dictionary is provided (\code{dict}),
will calculate the coverage (number of unique term matches) of each dictionary category.}
}
\value{
A matrix with texts represented by rows, and features in columns, unless there are multiple rows per output
 (e.g., when a latent semantic space is applied without terms being mapped) in which case only the special output
 is returned (e.g., a matrix with terms as rows and latent dimensions in columns).
}
\description{
A wrapper to other pre-processing functions, potentially from \code{\link{read.segments}}, to \code{\link{lma_dtm}}
or \code{\link{lma_patcat}}, to \code{\link{lma_weight}}, then \code{\link{lma_termcat}} or \code{\link{lma_lspace}},
and optionally including \code{\link{lma_meta}} output.
}
\examples{
# starting with some texts in a vector
texts <- c(
  "Firstly, I would like to say, and with all due respect...",
  "Please, proceed. I hope you feel you can speak freely...",
  "Oh, of course, I just hope to be clear, and not cause offense...",
  "Oh, no, don't monitor yourself on my account..."
)

# by default, term counts and metastatistics are returned
lma_process(texts)

# add dictionary and percent arguments for standard dictionary-based results
lma_process(texts, dict = lma_dict(), percent = TRUE)

# add space and weight arguments for standard word-centroid vectors
lma_process(texts, space = lma_lspace(texts), weight = "tfidf")
}
\seealso{
If you just want to compare texts, see the \code{\link{lingmatch}()} function.
}
