% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt.R
\name{register_dt}
\alias{register_dt}
\title{Register a DT DataTable Component}
\usage{
register_dt(
  session,
  registry,
  dt_output_id,
  data_reactive,
  shared_id_column,
  click_handler = NULL
)
}
\arguments{
\item{session}{'shiny' session object. The session from the module where the DT is used. This could be global session in non-modular apps.}

\item{registry}{A link registry created by \code{\link[=create_link_registry]{create_link_registry()}}}

\item{dt_output_id}{Character string: the outputId of your \link[DT:dataTableOutput]{DT::DTOutput}}

\item{data_reactive}{Reactive expression returning the data frame for the table}

\item{shared_id_column}{Character string: name of the ID column}

\item{click_handler}{Optional function: custom click handler for row selection, must have args (map_proxy, selected_data, session), overrides all default behavior}
}
\value{
NULL (invisible). This function is called for its side effects of registering the component.
}
\description{
\code{register_dt} registers a DT datatable for linking with other components.
}
\examples{
\donttest{
  # Create a mock session for the example
  session <- shiny::MockShinySession$new()

  # Create a registry
  registry <- create_link_registry(session)

  # Sample reactive data
  my_data <- shiny::reactive({
    data.frame(
      id = 1:5,
      name = c("A", "B", "C", "D", "E"),
      value = 11:15
    )
  })

  # Register a DT component
  register_dt(session, registry, "my_table", my_data, "id")

  # Verify registration
  print(registry$get_components())
}
}
