% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BeEFdiscretization_numnum.R
\name{BeEFdiscretization.numnum}
\alias{BeEFdiscretization.numnum}
\title{BeEF: Best Equal-Frequency discretization (for a couple of quantitative variables)}
\usage{
BeEFdiscretization.numnum(
  continuousX,
  continuousY,
  maxNbBins = 100,
  includeNA = T,
  showProgress = F
)
}
\arguments{
\item{continuousX}{a vector of numeric.}

\item{continuousY}{a vector of numeric.}

\item{maxNbBins}{an integer corresponding to the number of bins limitation (for computation time limitation), maxNbBins=100 by default.}

\item{includeNA}{a boolean. TRUE to include NA value as a factor level.}

\item{showProgress}{a boolean to decide whether to show the progress bar.}
}
\value{
a list of two factors.
}
\description{
Discretize two quantitative variables by optimizing the obtained the Normalized Mutual Information
}
\examples{
# calculate a correlation dataframe
data(iris)
disc=BeEFdiscretization.numnum(iris$Sepal.Length,iris$Sepal.Width)
summary(disc$x)
summary(disc$y)

}
