% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output-fxns.R
\name{time_to_prop_mass_remaining}
\alias{time_to_prop_mass_remaining}
\title{Get the predicted time until half mass loss for a litter decomposition trajectory}
\usage{
time_to_prop_mass_remaining(x,threshold.mass=0.5)
}
\arguments{
\item{x}{a litfit object}

\item{threshold.mass}{mass loss threshold in proportion, default is 0.5}
}
\value{
numeric value that represents time to a specified mass loss percentage
}
\description{
Get estimated time to 0.5 (or an alternate threshold) mass loss from a particular fit to a litter decomposition trajectory
}
\details{
this function finds the time to a specified mass loss percentage
}
\examples{

 fit<-fit_litter(time=pineneedles$Year,mass.remaining=pineneedles$Mass.remaining,
 model='neg.exp',iters=1000)
 time_to_prop_mass_remaining(fit, threshold.mass = 0.5)

}
\seealso{
\code{\link{fit_litter}} \code{\link{plot.litfit}}
}
\author{
Will Cornwell
}
