% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_forc_general.R
\name{is_forc_general}
\alias{is_forc_general}
\title{In-sample general model forecast}
\usage{
is_forc_general(model_function, prediction_function, data, realized, time_vec)
}
\arguments{
\item{model_function}{Function that estimates a model using the \code{data} input.}

\item{prediction_function}{Function that generates model predictions using \code{model_function} and \code{data} as inputs.}

\item{data}{Input data for estimating the model.}

\item{realized}{Vector of realized values of the dependent variable equal in length to the data in \code{data}.}

\item{time_vec}{Vector of any class that represents time and is equal in length to the length of \code{realized} and \code{data}.}
}
\value{
\code{\link{Forecast}} object that contains the in-sample forecast.
}
\description{
\code{is_forc_general} takes a model function, a prediction function, input
data for estimating the model, realized values of the dependent variable,
and an optional vector of time data associated with the model. The model is
estimated once over the entire sample period using the input data and model function.
Model parameters are then combined with the input data using the prediction function
to generate in-sample forecasts. Returns an in-sample forecast conditional on realized values.
}
\examples{

date <- as.Date(c("2010-03-31", "2010-06-30", "2010-09-30", "2010-12-31",
                  "2011-03-31", "2011-06-30", "2011-09-30", "2011-12-31", 
                  "2012-03-31", "2012-06-30"))
y  <- c(1, 0, 0, 0, 1, 1, 0, 0, 0, 1)
x1 <- c(8.22, 3.86, 4.27, 3.37, 5.88, 3.34, 2.92, 1.80, 3.30, 7.17)
x2 <- c(4.03, 2.46, 2.04, 2.44, 6.09, 2.91, 1.68, 2.91, 3.87, 1.63)
dataLogit <- data.frame(date, y, x1, x2)

is_forc_general(
  model_function = function(data) {glm(y ~ x1 + x2, data = data, family = binomial)},
  prediction_function = function(model_function, data) {
      as.vector(predict(model_function, data, type = "response"))
  }, 
  data = dataLogit,
  realized = dataLogit$y,
  time_vec = dataLogit$date
)

}
\seealso{
For a detailed example see the help vignette:
\code{vignette("lmForc", package = "lmForc")}
}
