% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oos_vintage_forc.R
\name{oos_vintage_forc}
\alias{oos_vintage_forc}
\title{Out-of-sample linear model forecast conditioned on vintage forecasts}
\usage{
oos_vintage_forc(
  lm_call,
  time_vec,
  ...,
  estimation_window = NULL,
  return_betas = FALSE
)
}
\arguments{
\item{lm_call}{Linear model call of the class lm.}

\item{time_vec}{Vector of any class that is equal in length to the data
in \code{lm_call}.}

\item{...}{Set of forecasts of class Forecast, one forecast for each
covariate in the linear model.}

\item{estimation_window}{Integer representing the number of past periods
that the linear model should be estimated over in each period.}

\item{return_betas}{Boolean, selects whether the coefficients used in each
period to create the forecast are returned. If TRUE, a data frame of
betas is returned to the Global Environment.}
}
\value{
\code{\link{Forecast}} object that contains the out-of-sample
forecast.
}
\description{
\code{oos_vintage_forc} takes a linear model call, a vector of time data
associated with the linear model, a forecast for each covariate in the
linear model, and an optional integer number of past periods to estimate the
linear model over. For each period in the vintage forecasts, coefficients are
estimated with data up to the current period minus the number of periods
specified in \code{estimation_window}. If \code{estimation_window} is left
\code{NULL} then the linear model is estimated with all available data up to
the current period. Coefficients are then multiplied by vintage forecast values.
Returns an out-of-sample forecast conditional on vintage forecasts that
\strong{would} have been available at the forecast origin. Optionally returns
the coefficients used to create each forecast. Replicates the forecasts that a
linear model would have produced in real time.
}
\examples{
date <- as.Date(c("2010-03-31", "2010-06-30", "2010-09-30", "2010-12-31",
                  "2011-03-31", "2011-06-30", "2011-09-30", "2011-12-31", 
                  "2012-03-31", "2012-06-30"))
y  <- c(1.09, 1.71, 1.09, 2.46, 1.78, 1.35, 2.89, 2.11, 2.97, 0.99)
x1 <- c(4.22, 3.86, 4.27, 5.60, 5.11, 4.31, 4.92, 5.80, 6.30, 4.17)
x2  <- c(10.03, 10.49, 10.85, 10.47, 9.09, 10.91, 8.68, 9.91, 7.87, 6.63)
data <- data.frame(date, y, x1, x2)

x1_forecast_vintage <- Forecast(
   origin   = as.Date(c("2010-09-30", "2010-12-31", "2011-03-31", "2011-06-30")),
   future   = as.Date(c("2011-09-30", "2011-12-31", "2012-03-31", "2012-06-30")),
   forecast = c(6.30, 4.17, 5.30, 4.84),
   realized = c(4.92, 5.80, 6.30, 4.17),
   h_ahead  = 4L
)

x2_forecast_vintage <- Forecast(
   origin   = as.Date(c("2010-09-30", "2010-12-31", "2011-03-31", "2011-06-30")),
   future   = as.Date(c("2011-09-30", "2011-12-31", "2012-03-31", "2012-06-30")),
 forecast = c(7.32, 6.88, 6.82, 6.95),
 realized = c(8.68, 9.91, 7.87, 6.63),
 h_ahead  = 4L
) 

oos_vintage_forc(
  lm_call = lm(y ~ x1 + x2, data),
  time_vec = data$date,
  x1_forecast_vintage, x2_forecast_vintage,
  estimation_window = 4L,
  return_betas = FALSE
)

oos_vintage_forc(
  lm_call = lm(y ~ x1 + x2, data),
  time_vec = data$date,
  x1_forecast_vintage, x2_forecast_vintage
)

}
\seealso{
For a detailed example see the help vignette:
\code{vignette("lmForc", package = "lmForc")}
}
