% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputerDecision.default.r
\name{ComputerDecision.default}
\alias{ComputerDecision.default}
\title{Computer player decision}
\usage{
ComputerDecision.default(fit)
}
\arguments{
\item{fit}{an object returned by \code{\link[stats]{lm}}}
}
\value{
An integer between 1 and 4 where 1=non linearity; 2=heteroscedasticity; 3=non normality; 4=no violation
}
\description{
Decides whether a fitted lm objects residuals are such that a violation of the assumptions of non linearity, heteroscedasticity, non normality occurs
}
\details{
The computer answer is determined by a sequence of tests.
In particular, a test for non linearity is performed (if the sample size is greater than 30 the program tests for the significance of a non linear regression on the residuals versus x, otherwise Ramsey's RESET test is performed), if the null hypothesis is rejected the computer answer will be non linearity, if not, the Breusch-Pagan test for heteroscedasticity is performed, if the null hypothesis is rejected the computer answer will be heteroscedasticity, otherwise the Shapiro-Wilks test of normality is performed and the answer will be non normality if the null hypothesis is rejected; if no test is significant the answer will be `no violation'.
(Functions to perform the tests are from the package {\code{lmtest}}.)
}
\examples{
x=rnorm(10)
y=x+rnorm(10,0,0.4)
fit=lm(y~x)
ComputerDecision.default(fit)

x=rnorm(30)
y=x+rt(30,2)
fit=lm(y~x)
ComputerDecision.default(fit)

}
\seealso{
\code{\link{Simulation.default}}, \code{\link{checksim}}
}
\author{
Francesco Pauli, \email{francesco.pauli@deams.units.it}
}
