% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag_client_registrant_conflict.R
\name{flag_client_registrant_conflict}
\alias{flag_client_registrant_conflict}
\title{Identify and Resolve Potential Double-Counting of Client/Registrant}
\usage{
flag_client_registrant_conflict(
  dataframe_that_i_determine,
  flag_conflict = TRUE,
  clean_doublecounts = TRUE
)
}
\arguments{
\item{dataframe_that_i_determine}{A data frame, typically the name of the output from [get_filings()], containing lobbying filings for a given query.}

\item{flag_conflict}{Logical. If \code{TRUE} (default), the function flags filings that are likely duplicates as described above.}

\item{clean_doublecounts}{Logical. If \code{TRUE} (default), the function automatically filters out cases that could lead to double-counting.}
}
\value{
A data frame with a new flag column and, optionally, with potential double-counting cases filtered out.
}
\description{
Flags instances where an entity filed as a registrant (which, if following the rules, should include all lobbying spending by that entity) but also appeared as a client in filings by outside lobbyists. This helps avoid double-counting lobbying expenses.
}
\details{
This function identifies:
\itemize{
  \item Self-lobbying entities (where registrant and client names match), which should include all lobbying spending.
  \item Cases where the same entity appears as a client in filings by other lobbyists, which should be excluded from aggregate totals to avoid double-counting.
}
The function adds a flag column to the data frame, indicating whether each filing is a "Report of all entity's spending", "Likely part of separate entity's report", or "No entity's report detected". If \code{clean_doublecounts = TRUE}, filings that are likely to cause double-counting are removed.

Note: This function is not perfect and may miss some edge cases. Manual review is recommended for critical analyses.
}
\examples{
\dontrun{
# Flag and clean potential double-counting cases
conflict_removed_and_flagged <- flag_client_registrant_conflict(
  cleaner_df, 
  flag_conflict = TRUE, 
  clean_doublecounts = TRUE
)

# Only flag, do not remove
conflict_flagged_only <- flag_client_registrant_conflict(
  cleaner_df, 
  flag_conflict = TRUE, 
  clean_doublecounts = FALSE
)
}

}
\seealso{
[get_filings()] for retrieving lobbying data, and [flag_dupes] for identifying duplicate or amended filings.
}
