% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{Logger}
\alias{Logger}
\title{Logger}
\description{
Create a logger.
}
\examples{
info <- Logger$new("INFO")$
 date()$
 time()$
 hook(crayon::blue)

info$log("Hello")
Sys.sleep(.7)
info$log("World")


## ------------------------------------------------
## Method `Logger$new`
## ------------------------------------------------

info <- Logger$new("INFO")
info$log("hello")

## ------------------------------------------------
## Method `Logger$date`
## ------------------------------------------------

info <- Logger$new("INFO")$date()
info$log("today")

## ------------------------------------------------
## Method `Logger$time`
## ------------------------------------------------

info <- Logger$new("INFO")$time()
info$log("now")

## ------------------------------------------------
## Method `Logger$unix`
## ------------------------------------------------

info <- Logger$new("INFO")$unix()
info$log("timestamp")

## ------------------------------------------------
## Method `Logger$hook`
## ------------------------------------------------

err <- Logger$new("INFO")$hook(crayon::red)
err$log("hello")

## ------------------------------------------------
## Method `Logger$dir`
## ------------------------------------------------

info <- Logger$new("INFO")$dir()
info$log("directory")

## ------------------------------------------------
## Method `Logger$flag`
## ------------------------------------------------

fl <- function(){
 paste0(sample(letters, 4), collapse = "")
}

info <- Logger$new("INFO")$flag(fl)
info$log("random")

## ------------------------------------------------
## Method `Logger$log`
## ------------------------------------------------

info <- Logger$new("INFO")
info$log("Logger")

## ------------------------------------------------
## Method `Logger$dump`
## ------------------------------------------------

info <- Logger$new("INFO")
info$log("hello")
\dontrun{info$dump()}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{printer}}{A callback function to write the message
to the console, must accept a single argument,
defaults to \code{cat}.}

\item{\code{predicate}}{A predicate function that determines whether
to actually run the log, useful if you want to switch the
logger on and off for debugging.

If the function returns \code{TRUE} the logger runs as normal,
if \code{FALSE} the logger does not actually print, write or
dump the messages.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Logger$new()}}
\item \href{#method-date}{\code{Logger$date()}}
\item \href{#method-time}{\code{Logger$time()}}
\item \href{#method-unix}{\code{Logger$unix()}}
\item \href{#method-hook}{\code{Logger$hook()}}
\item \href{#method-dir}{\code{Logger$dir()}}
\item \href{#method-flag}{\code{Logger$flag()}}
\item \href{#method-log}{\code{Logger$log()}}
\item \href{#method-dump}{\code{Logger$dump()}}
\item \href{#method-clone}{\code{Logger$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$new(prefix = NULL, write = FALSE, file = "log.log", sep = "\\t")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{String to prefix all log messages.}

\item{\code{write}}{Whether to write the log to the \code{file}.}

\item{\code{file}}{Name of the file to dump the logs to,
only used if \code{write} is \code{TRUE}.}

\item{\code{sep}}{Separator between \code{prefix} and other flags
and messages.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initialise
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{info <- Logger$new("INFO")
info$log("hello")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-date"></a>}}
\if{latex}{\out{\hypertarget{method-date}{}}}
\subsection{Method \code{date()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$date(format = "\%d-\%m-\%Y")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{format}}{Formatter for the item, passed
to \code{\link[=format]{format()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Include the date in the log
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{info <- Logger$new("INFO")$date()
info$log("today")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-time"></a>}}
\if{latex}{\out{\hypertarget{method-time}{}}}
\subsection{Method \code{time()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$time(format = "\%H:\%M:\%S")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{format}}{Formatter for the item, passed
to \code{\link[=format]{format()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Include the time in the log
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{info <- Logger$new("INFO")$time()
info$log("now")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-unix"></a>}}
\if{latex}{\out{\hypertarget{method-unix}{}}}
\subsection{Method \code{unix()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$unix()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Include the time in the log
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{info <- Logger$new("INFO")$unix()
info$log("timestamp")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hook"></a>}}
\if{latex}{\out{\hypertarget{method-hook}{}}}
\subsection{Method \code{hook()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$hook(fn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{A function that accepts one argument (string)
and returns a modified version of that string.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Preprocess the prefix with a custom function
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{err <- Logger$new("INFO")$hook(crayon::red)
err$log("hello")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dir"></a>}}
\if{latex}{\out{\hypertarget{method-dir}{}}}
\subsection{Method \code{dir()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$dir()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Include the directory in the log
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{info <- Logger$new("INFO")$dir()
info$log("directory")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-flag"></a>}}
\if{latex}{\out{\hypertarget{method-flag}{}}}
\subsection{Method \code{flag()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$flag(what)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{what}}{Function to run for every message logged
or string to include in log message.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Pass a custom flag
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{fl <- function(){
 paste0(sample(letters, 4), collapse = "")
}

info <- Logger$new("INFO")$flag(fl)
info$log("random")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-log"></a>}}
\if{latex}{\out{\hypertarget{method-log}{}}}
\subsection{Method \code{log()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$log(..., sep = " ", collapse = " ")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Elements to compose message.}

\item{\code{sep, collapse}}{Separators passed to \code{\link[=paste]{paste()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Log messages
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{info <- Logger$new("INFO")
info$log("Logger")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dump"></a>}}
\if{latex}{\out{\hypertarget{method-dump}{}}}
\subsection{Method \code{dump()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$dump(file = "dump.log")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{Name of the file to dump the logs to.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Dump the log to a file
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{info <- Logger$new("INFO")
info$log("hello")
\dontrun{info$dump()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
