% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autocorr.R
\name{computeEffectiveNumObs}
\alias{computeEffectiveNumObs}
\title{Compute the effective number of observations taking into account autocorrelation}
\usage{
computeEffectiveNumObs(
  res,
  effAcf = computeEffectiveAutoCorr(res),
  na.rm = FALSE,
  exact.na = TRUE
)
}
\arguments{
\item{res}{numeric of autocorrelated numbers, usually observation -
model residuals}

\item{effAcf}{autocorrelation coefficients.
The first entry is fixed at 1 for zero distance.}

\item{na.rm}{if not set to TRUE will return NA in there are missings
in the series}

\item{exact.na}{if set to FALSE then do not count and correct for missing
in the sum of autocorrelation terms. This is faster, but results are
increasingly biased high with increasing number of missings.}
}
\value{
integer scalar: effective number of observations
}
\description{
Compute the effective number of observations taking into account autocorrelation
}
\details{
Assumes records of all times present. 
DO NOT REMOVE OR FILTER NA records before. 
The length of the time series is used.

Handling of NA values: The formula from Zieba 2011 is extended
to subtract the number of missing pairs in the count of correlation terms.
If `exact.na=false` the original formula is used (after trimming edge-NAs).
}
\examples{
# generate autocorrelated time series
res <- stats::filter(rnorm(1000), filter = rep(1,5), circular = TRUE)
res[100:120] <- NA
# plot the series of autocorrelated random variables
plot(res)
# plot their empirical autocorrelation function
acf(res, na.action = na.pass)
#effAcf <- computeEffectiveAutoCorr(res)
# the effective number of parameters is less than number of 1000 samples
(nEff <- computeEffectiveNumObs(res, na.rm = TRUE))
}
\references{
\code{Zieba & Ramza (2011) 
Standard Deviation of the Mean of Autocorrelated 
Observations Estimated with the Use of the Autocorrelation Function 
Estimated From the Data. 
Metrology and Measurement Systems, 
Walter de Gruyter GmbH, 18 10.2478/v10178-011-0052-x}

\code{Bayley & Hammersley (1946) 
The "effective" number of independent observations in an autocorrelated 
time series. 
Supplement to the Journal of the Royal Statistical Society, JSTOR,8,184-197}
}
