% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lolog.R
\name{plot.lologGmm}
\alias{plot.lologGmm}
\title{Conduct Monte Carlo diagnostics on a lolog model fit}
\usage{
\method{plot}{lologGmm}(x, type = c("histograms", "target", "model"), ...)
}
\arguments{
\item{x}{A model fit object to be diagnosed.}

\item{type}{The type of diagnostic plot. "histograms", the default, produces histograms of the sampled
output statistic values with the observed statistics represented by vertical lines. "target" produces a pairs plot of the 
target output statistic values with the pairs of observed target statistics represented by red squares.
output statistic values with the observed statistics represented by vertical lines. "model" produces a pairs plot of the 
sampled output statistic values with the pairs of observed statistics represented by red squares.}

\item{...}{Additional parameters. Passed to \link[ggplot2]{geom_histogram} if type="histogram" 
and \link{pairs} otherwise.}
}
\description{
This function creates simple diagnostic
plots for MC sampled statistics produced from a lolog fit.
}
\details{
Plots are produced that represent the distributions of the 
output sampled statistic values or the target statistics values.
The values of the observed target statistics for the networks are
also represented for comparison with the sampled statistics.
}
\examples{
library(network)
set.seed(1)
data(flo)
flomarriage <- network(flo,directed=FALSE)
flomarriage \%v\% "wealth" <- c(10,36,27,146,55,44,20,8,42,103,48,49,10,48,32,3)


# An order dependent model
fit3 <- lolog(flomarriage ~ edges + nodeCov("wealth") + preferentialAttachment(),
              flomarriage ~ star(2:3), verbose=FALSE)
plot(fit3)
plot(fit3, "target")
plot(fit3, "model")
}
