% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipsum.R
\name{ipsum}
\alias{ipsum}
\alias{ipsum_words}
\alias{ipsum_starts}
\title{Generate Lorem Ipsum Text}
\usage{
ipsum(paragraphs = 1, sentences = NULL, avg_words_per_sentence = 10)

ipsum_words(n, collapse = TRUE)

ipsum_starts(n)
}
\arguments{
\item{paragraphs}{Number of paragraphs of text to generate.}

\item{sentences}{Number of sentences per paragraph. If \code{NULL}, then a random
number of sentences per paragraph (approximately 3-8) will be chosen.
Alternatively, \code{sentences} can be a vector of integers representing the
number of sentences per paragraph.}

\item{avg_words_per_sentence}{Number of expected words per sentence.}

\item{n}{Number of words to generate}

\item{collapse}{Should the words be collapsed into a single string, separated
by spaces (default)? If \code{FALSE}, the chosen words are returned as a
character vector.}
}
\value{
A character vector of \emph{lorem ispum} placeholder text, where each
element in the vector is a paragraph of text.
}
\description{
Generates \emph{lorem ipsum} placeholder text for the requested number of
sentences or paragraphs. You can control the number of sentences per
paragraph and the average number of words per sentence, or simply enter the
number of desired paragraphs for a completely random experience.

\code{lorem::ipsum()} uses sampling and the random number generator and makes no
effort to shield the placeholder text generation from the main script, so
please only use this package for temporary placeholder text.
}
\section{Functions}{
\itemize{
\item \code{ipsum()}: Generate paragraphs and sentences of \emph{lorem ipsum} text.

\item \code{ipsum_words()}: Generate \emph{lorem ipsum} words, without punctuation.

\item \code{ipsum_starts()}: Generate \emph{lorem ipsum} starting words.

}}
\section{Options}{


You can influence, to a degree, the amount of punctuation that is included
in the output using the \code{lorem.punctuation_valence} option. This global
option should be a number between 0 and 1, or \code{FALSE} to disable
punctuation altogether. When the value is closer to 1, more punctuation is
included in the sentences. When the value is closer to 0, less punctuation
will be inserted. The default value is 0.4.
}

\examples{
# 1 paragraph of text
lorem::ipsum(1)

# 2 paragraphs with 2 and 3 sentences each
lorem::ipsum(2, sentences = c(2, 3))

# 2 paragraphs with short sentences
lorem::ipsum(2, avg_words_per_sentence = 4)

# 2 paragraphs with long sentences
lorem::ipsum(2, avg_words_per_sentence = 20)

}
