% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lori.R
\name{lori}
\alias{lori}
\title{The lori method implements a method to analyze and impute
incomplete count tables. An important feature of the method
is that it can take into account main effects of rows and
columns, as well as effects of continuous or categorical
covariates, and interaction. The estimation procedure is
based on minimizing a Poisson loss penalized by a Lasso
type penalty (sparse vector of covariate effects) and a
nuclear norm penalty inducing a low-rank interaction matrix
(a few latent factors summarize the interactions).}
\usage{
lori(
  Y,
  cov = NULL,
  lambda1 = NULL,
  lambda2 = NULL,
  intercept = T,
  reff = T,
  ceff = T,
  rank.max = 2,
  algo = c("alt", "mcgd"),
  thresh = 1e-05,
  maxit = 100,
  trace.it = F,
  parallel = F
)
}
\arguments{
\item{Y}{[matrix, data.frame] count table (nxp).}

\item{cov}{[matrix, data.frame] design matrix (np*q) in order row1xcol1,row2xcol2,..,rownxcol1,row1xcol2,row2xcol2,...,...,rownxcolp}

\item{lambda1}{[positive number] the regularization parameter for the interaction matrix.}

\item{lambda2}{[positive number] the regularization parameter for the covariate effects.}

\item{intercept}{[boolean] whether an intercept should be fitted, default value is FALSE}

\item{reff}{[boolean] whether row effects should be fitted, default value is TRUE}

\item{ceff}{[boolean] whether column effects should be fitted, default value is TRUE}

\item{rank.max}{[integer] maximum rank of interaction matrix (smaller than min(n-1,p-1))}

\item{algo}{type of algorithm to use, either one of "mcgd" (mixed coordinate gradient descent, adapted to large dimensions) or "alt" (alternating minimization, adapted to small dimensions)}

\item{thresh}{[positive number] convergence tolerance of algorithm, by default \code{1e-6}.}

\item{maxit}{[integer] maximum allowed number of iterations.}

\item{trace.it}{[boolean] whether convergence information should be printed}

\item{parallel}{[boolean] whether computations should be performed in parallel on multiple cores}
}
\value{
A list with the following elements
\item{X}{nxp matrix of log of expected counts}
\item{alpha}{row effects}
\item{beta}{column effects}
\item{epsilon}{covariate effects}
\item{theta}{nxp matrix of row-column interactions}
\item{imputed}{nxp matrix of imputed counts}
\item{means}{nxp matrix of expected counts (exp(X))}
\item{cov}{npxK matrix of covariates}
\item{nparam}{number of estimated parameters in the model}
\item{dfres}{residual degrees of freedom}
\item{chisq}{sum of squared deviations between observed and expected counts normalized by the expected value}
}
\description{
The lori method implements a method to analyze and impute
incomplete count tables. An important feature of the method
is that it can take into account main effects of rows and
columns, as well as effects of continuous or categorical
covariates, and interaction. The estimation procedure is
based on minimizing a Poisson loss penalized by a Lasso
type penalty (sparse vector of covariate effects) and a
nuclear norm penalty inducing a low-rank interaction matrix
(a few latent factors summarize the interactions).
}
\examples{
\dontshow{
X <- matrix(rnorm(50), 25)
Y <- matrix(rpois(25, 1:25), 5)
res <- lori(Y, X, 10, 10)
}
}
