% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust2integers.R
\name{adjust2integers}
\alias{adjust2integers}
\title{Integer-adjusting of outputs of the lphom-family functions}
\usage{
adjust2integers(x, solver = "symphony", ...)
}
\arguments{
\item{x}{An object output of a lphom family algorithm}

\item{solver}{A character string indicating the linear programming solver to be used to approximate
to the closest integer solution, only \code{symphony} and \code{lp_solve} are allowed.
By default, \code{symphony}. The package \code{Rsymphony} needs to be installed for the option \code{symphony}
to be used.}

\item{...}{Other arguments passed on the method. Not currently used.}
}
\value{
An object of the same class and components as \code{x} with its components properly updated after adjusting the estimated count matrices in \code{x} using integer linear programming
}
\description{
Takes as input an object generated with an algorithm of the lphom-family
(lphom, tslphom, nslphom, tslphom_dual, nslphom_joint, ....) and returns
as output an object of the same class as the input object with all their relevant estimated (local and global) transfer matrices
of counts updated to their closest integer matrices. The rest of main components of the object are also accordingly updated.
}
\details{
The updating of the matrices is performed using integer linear programming after imposing all the row- and column-constraints.
}
\examples{
mt.ts <- tslphom(France2017P[, 1:8] , France2017P[, 9:12], new_and_exit_voters= "raw")
mt.ts <- adjust2integers(mt.ts, solver = "lp_solve")
}
\references{
Pavia, JM (2024). Integer estimation of inner-cell values in RxC ecological tables. \emph{Bulletin of Sociological Methodology}, 164(1), 97-121. \doi{10.1177/07591063241277064}.
}
\author{
Jose M. Pavia, \email{pavia@uv.es}
}
