% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lrsimsub}
\alias{lrsimsub}
\title{Log-Rank Test Simulation for Enrichment Design}
\usage{
lrsimsub(
  kMax = 1L,
  kMaxitt = 1L,
  hazardRatioH0itt = 1,
  hazardRatioH0pos = 1,
  hazardRatioH0neg = 1,
  allocation1 = 1L,
  allocation2 = 1L,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  p_pos = NA_real_,
  lambda1itt = NA_real_,
  lambda2itt = NA_real_,
  lambda1pos = NA_real_,
  lambda2pos = NA_real_,
  gamma1itt = 0L,
  gamma2itt = 0L,
  gamma1pos = 0L,
  gamma2pos = 0L,
  accrualDuration = NA_real_,
  followupTime = NA_real_,
  fixedFollowup = 0L,
  rho1 = 0,
  rho2 = 0,
  plannedEvents = NA_integer_,
  plannedTime = NA_real_,
  maxNumberOfIterations = 1000L,
  maxNumberOfRawDatasetsPerStage = 0L,
  seed = NA_integer_
)
}
\arguments{
\item{kMax}{The maximum number of stages.}

\item{kMaxitt}{Number of stages with timing determined by events
in the ITT population. Ranges from 0 (none) to \code{kMax}.}

\item{hazardRatioH0itt}{Hazard ratio under the null hypothesis
for the ITT population. Defaults to 1 for superiority test.}

\item{hazardRatioH0pos}{Hazard ratio under the null hypothesis
for the biomarker positive sub population. Defaults to 1 for
superiority test.}

\item{hazardRatioH0neg}{Hazard ratio under the null hypothesis
for the biomarker negative sub population. Defaults to 1 for
superiority test.}

\item{allocation1}{Number of subjects in the treatment group in
a randomization block. Defaults to 1 for equal randomization.}

\item{allocation2}{Number of subjects in the control group in
a randomization block. Defaults to 1 for equal randomization.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{p_pos}{The prevalence of the biomarker positive sub population
in each stratum.}

\item{lambda1itt}{A vector of hazard rates for the event in each analysis
time interval by stratum for the treatment group in the ITT population.}

\item{lambda2itt}{A vector of hazard rates for the event in each analysis
time interval by stratum for the control group in the ITT population.}

\item{lambda1pos}{A vector of hazard rates for the event in each analysis
time interval by stratum for the treatment group in the biomarker
positive sub population.}

\item{lambda2pos}{A vector of hazard rates for the event in each analysis
time interval by stratum for the control group in the biomarker
positive sub population.}

\item{gamma1itt}{The hazard rate for exponential dropout, a vector of
hazard rates for piecewise exponential dropout applicable for all
strata, or a vector of hazard rates for dropout in each analysis time
interval by stratum for the treatment group in the ITT population.}

\item{gamma2itt}{The hazard rate for exponential dropout, a vector of
hazard rates for piecewise exponential dropout applicable for all
strata, or a vector of hazard rates for dropout in each analysis time
interval by stratum for the control group in the ITT population.}

\item{gamma1pos}{The hazard rate for exponential dropout, a vector of
hazard rates for piecewise exponential dropout applicable for all
strata, or a vector of hazard rates for dropout in each analysis time
interval by stratum for the treatment group in the biomarker
positive sub population.}

\item{gamma2pos}{The hazard rate for exponential dropout, a vector of
hazard rates for piecewise exponential dropout applicable for all
strata, or a vector of hazard rates for dropout in each analysis time
interval by stratum for the control group in the biomarker
positive sub population.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{rho1}{The first parameter of the Fleming-Harrington family of
weighted log-rank test. Defaults to 0 for conventional log-rank test.}

\item{rho2}{The second parameter of the Fleming-Harrington family of
weighted log-rank test. Defaults to 0 for conventional log-rank test.}

\item{plannedEvents}{The planned cumulative total number events in the
ITT population at Look 1 to Look \code{kMaxitt} and the planned
cumulative total number of events at Look \code{kMaxitt+1} to
Look \code{kMax} in the biomarker positive sub population.}

\item{plannedTime}{The calendar times for the analyses. To use calendar
time to plan the analyses, \code{plannedEvents} should be missing.}

\item{maxNumberOfIterations}{The number of simulation iterations.
Defaults to 1000.}

\item{maxNumberOfRawDatasetsPerStage}{The number of raw datasets per
stage to extract.}

\item{seed}{The seed to reproduce the simulation results.
The seed from the environment will be used if left unspecified.}
}
\value{
A list with 2 components:
\itemize{
\item \code{sumdata}: A data frame of summary data by iteration and stage:
\itemize{
\item \code{iterationNumber}: The iteration number.
\item \code{eventsNotAchieved}: Whether the target number of events
is not achieved for the iteration.
\item \code{stageNumber}: The stage number, covering all stages even if
the trial stops at an interim look.
\item \code{analysisTime}: The time for the stage since trial start.
\item \code{population}: The population ("ITT", "Biomarker Positive",
"Biomarker Negative") under consideration.
\item \code{accruals1}: The number of subjects enrolled at the stage for
the treatment group.
\item \code{accruals2}: The number of subjects enrolled at the stage for
the control group.
\item \code{totalAccruals}: The total number of subjects enrolled at
the stage.
\item \code{events1}: The number of events at the stage for
the treatment group.
\item \code{events2}: The number of events at the stage for
the control group.
\item \code{totalEvents}: The total number of events at the stage.
\item \code{dropouts1}: The number of dropouts at the stage for
the treatment group.
\item \code{dropouts2}: The number of dropouts at the stage for
the control group.
\item \code{totalDropouts}: The total number of dropouts at the stage.
\item \code{logRankStatistic}: The log-rank test Z-statistic for
the population.
}
\item \code{rawdata} (exists if \code{maxNumberOfRawDatasetsPerStage} is a
positive integer): A data frame for subject-level data for selected
replications, containing the following variables:
\itemize{
\item \code{iterationNumber}: The iteration number.
\item \code{stageNumber}: The stage under consideration.
\item \code{analysisTime}: The time for the stage since trial start.
\item \code{subjectId}: The subject ID.
\item \code{arrivalTime}: The enrollment time for the subject.
\item \code{stratum}: The stratum for the subject.
\item \code{biomarker}: The biomarker status for the subject (1 for
positive, 0 for negative).
\item \code{treatmentGroup}: The treatment group (1 or 2) for the
subject.
\item \code{survivalTime}: The underlying survival time for the subject.
\item \code{dropoutTime}: The underlying dropout time for the subject.
\item \code{timeUnderObservation}: The time under observation
since randomization for the subject.
\item \code{event}: Whether the subject experienced an event.
\item \code{dropoutEvent}: Whether the subject dropped out.
}
}
}
\description{
Performs simulation for two-arm group
sequential trials based on weighted log-rank test
for a biomarker enrichment design. The looks are either
driven by the total number of events in the ITT population
or the biomarker positive sub population.
Alternatively, the analyses can be planned to occur at
specified calendar times.
}
\examples{

sim1 = lrsimsub(
  kMax = 2,
  kMaxitt = 2,
  allocation1 = 1,
  allocation2 = 1,
  accrualTime = seq(0,9),
  accrualIntensity = c(seq(10,70,10),rep(70,3)),
  piecewiseSurvivalTime = c(0,12,24),
  p_pos = 0.6,
  lambda1itt = c(0.00256, 0.00383, 0.00700),
  lambda2itt = c(0.00427, 0.00638, 0.01167),
  lambda1pos = c(0.00299, 0.00430, 0.01064),
  lambda2pos = c(0.00516, 0.00741, 0.01835),
  gamma1itt = -log(1-0.04)/12,
  gamma2itt = -log(1-0.04)/12,
  gamma1pos = -log(1-0.04)/12,
  gamma2pos = -log(1-0.04)/12,
  accrualDuration = 10.14,
  plannedEvents = c(108,144),
  maxNumberOfIterations = 1000,
  maxNumberOfRawDatasetsPerStage = 1,
  seed = 314159)

head(sim1$sumdata)
head(sim1$rawdata)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
