% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lunar.package.R
\name{terrestrial.season}
\alias{terrestrial.season}
\title{Terrestrial Season}
\usage{
terrestrial.season(
  x,
  cutoffs = c(80, 172, 263, 354),
  southern.hemisphere = FALSE
)
}
\arguments{
\item{x}{A vector of \code{\link[base]{Date}} values.}

\item{cutoffs}{A vector of numbers corresponding to days of the year when
season labels change.}

\item{southern.hemisphere}{The season labels follow a northern hemisphere order unless
this option is set to TRUE.}
}
\description{
Returns the season on specified dates.
}
\details{
The definitions for non-leap years are as follows
  (dates are inclusive):
  \describe{
    \item{Winter:}{21 December through 21 March}
    \item{Spring:}{22 March through 21 June}
    \item{Summer:}{22 June through 20 September}
    \item{Autumn:}{21 September through 20 December}
  }
  In leap years spring comes a day early!
  Thanks to Mehis Rohtla for finding an error in the 0.1-04 version code.
}
\examples{
terrestrial.season(as.Date("2017-03-21"))
terrestrial.season(as.Date("2017-03-22"))
terrestrial.season(as.Date("2017-12-20"), southern.hemisphere = TRUE)
terrestrial.season(as.Date("2017-12-21"), southern.hemisphere = TRUE)
}
\seealso{
\code{\link{terrestrial.seasons}}
}
\keyword{earth}
\keyword{season}
