% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_run_sequence.R
\name{get_run_sequence}
\alias{get_run_sequence}
\title{Get the run sequence of a schedule}
\usage{
get_run_sequence(
  schedule,
  n = NULL,
  min_datetime = NULL,
  max_datetime = NULL,
  include_only_primary = FALSE
)
}
\arguments{
\item{schedule}{object of type MaestroSchedule created using \code{build_schedule()}}

\item{n}{Optional positive integer. If specified, returns only the first \code{n} runs for each pipeline.}

\item{min_datetime}{Optional minimum datetime filter. Can be a \link[lubridate:date_utils]{lubridate::Date} or \link[lubridate:posix_utils]{lubridate::POSIXct} object.
If specified, only returns runs scheduled at or after this datetime.}

\item{max_datetime}{Optional maximum datetime filter. Can be a \link[lubridate:date_utils]{lubridate::Date} or \link[lubridate:posix_utils]{lubridate::POSIXct} object.
If specified, only returns runs scheduled at or before this datetime.}

\item{include_only_primary}{only primary pipelines are included
(this are pipelines that are scheduled and not downstream nodes in a DAG)}
}
\value{
A vector of datetime values representing the scheduled run times.
}
\description{
Retrieves the scheduled run times for a given schedule, with optional filtering
by number of runs and datetime range.
}
\examples{
if (interactive()) {
  pipeline_dir <- tempdir()
  create_pipeline("my_new_pipeline", pipeline_dir, open = FALSE)
  schedule <- build_schedule(pipeline_dir = pipeline_dir)

  get_run_sequence(schedule)

  # Alternatively, use the underlying R6 method
  schedule$get_run_sequence()
}
}
