% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_with_dir.R
\name{make_with_dir}
\alias{make_with_dir}
\alias{make_with_roxy}
\title{Create a pipeline using roxygen tags}
\usage{
make_with_dir(
  dir = ".",
  recursive = FALSE,
  build = TRUE,
  envir = new.env(parent = parent.frame()),
  quiet = getOption("makepipe.quiet")
)

make_with_roxy(
  source,
  envir = new.env(parent = parent.frame()),
  quiet = getOption("makepipe.quiet"),
  build = TRUE
)
}
\arguments{
\item{dir}{A character vector of full path names; the default corresponds to the working directory}

\item{recursive}{A logical determining whether or not to recurse into
subdirectories}

\item{build}{A logical determining whether or not the pipeline/segment will be built
immediately or simply returned to the user}

\item{envir}{The environment in which to execute the \code{source} or \code{recipe}. By
default, execution will take place in a fresh environment whose parent is
the calling environment.}

\item{quiet}{A logical determining whether or not messages are signaled}

\item{source}{The path to an R script which makes the \code{targets}}
}
\value{
A \code{Pipeline} object
}
\description{
Instead of maintaining a separate pipeline script containing calls to
\code{make_with_source()}, you can add roxygen-like headers to the .R files in
your pipeline containing the \verb{@makepipe} tag along with \verb{@targets},
\verb{@dependencies}, and so on. These tags will be parsed by \code{make_with_dir()}
and used to construct a pipeline. You can call a specific part of the
pipeline that has been documented in this way using \code{make_with_roxy()}.
}
\details{
Other than \verb{@makepipe}, which is used to tell whether a given script should
be included in the pipeline, the tags recognised mirror the arguments to
\code{make_with_source()}. In particular,
\itemize{
\item \verb{@targets} and \verb{@dependencies} are for declaring inputs and outputs, the
expected format is a comma separated list of strings like
\verb{@targets "out1.Rds", "out2.Rds"} but R code like \verb{@targets file.path(DIR, "out.Rds")}
(evaluated in \code{envir}) works too
\item \verb{@packages} is for declaring the packages that the targets depend on, the
expected format is \verb{@packages pkg1 pkg2 etc}
\item \verb{@force} is for declaring whether or not execution should be forced, the
expected format is a logical like \code{TRUE} or \code{FALSE}
}

See the getting started vignette for more information.
}
\examples{
\dontrun{
# Create a pipeline from scripts in the working dir without executing it
p <- make_with_dir(build = FALSE)
p$build() # Then execute it yourself
}
}
\seealso{
Other make: 
\code{\link{make_with_recipe}()},
\code{\link{make_with_source}()}
}
\concept{make}
