% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_spectra.R
\name{process_spectra}
\alias{process_spectra}
\title{Process Bruker MALDI Biotyper spectra \emph{à la} Strejcek et al. (2018)}
\usage{
process_spectra(
  spectra_list,
  spectra_names = get_spectra_names(spectra_list),
  rds_prefix = deprecated()
)
}
\arguments{
\item{spectra_list}{A list of \link[MALDIquant:MassSpectrum-class]{MALDIquant::MassSpectrum} objects.}

\item{spectra_names}{A \link[tibble:tibble]{tibble::tibble} (or \link{data.frame}) of sanitized spectra names by default from \link{get_spectra_names}. If provided manually, the column \code{sanitized_name} will be used to name the spectra.}

\item{rds_prefix}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Writing to disk as RDS is no longer supported. A character indicating the prefix for the \code{.RDS} output files to be written in the \code{processed} directory. By default, no prefix are given and thus no files are written.}
}
\value{
A named list of three objects:
\itemize{
\item \code{spectra}: a list the length of the spectra list of \link[MALDIquant:MassSpectrum-class]{MALDIquant::MassSpectrum} objects.
\item \code{peaks}: a list the length of the spectra list of \link[MALDIquant:MassPeaks-class]{MALDIquant::MassPeaks} objects.
\item \code{metadata}: a tibble indicating the median signal-to-noise ratio (\code{SNR}) and peaks number for all spectra list (\code{peaks}), with spectra names in the \code{name} column.
}
}
\description{
Process Bruker MALDI Biotyper spectra \emph{à la} Strejcek et al. (2018)
}
\details{
Based on the original implementation, the function performs the following tasks:
\enumerate{
\item Square-root transformation
\item Mass range trimming to 4-10 kDa as they were deemed most determinant by Strejcek et al. (2018)
\item Signal smoothing using the Savitzky-Golay method and a half window size of 20
\item Baseline correction with the SNIP procedure
\item Normalization by Total Ion Current
\item Peak detection using the SuperSmoother procedure and with a signal-to-noise ratio above 3
\item Peak filtering. This step has been added to discard peaks with a negative signal-to-noise ratio probably due to being on the edge of the mass range.
}
}
\note{
The original R code on which this function is based is accessible at: \url{https://github.com/strejcem/MALDIvs16S}
}
\examples{
# Get an example directory of six Bruker MALDI Biotyper spectra
directory_biotyper_spectra <- system.file(
  "toy-species-spectra",
  package = "maldipickr"
)
# Import the six spectra
spectra_list <- import_biotyper_spectra(directory_biotyper_spectra)
# Transform the spectra signals according to Strejcek et al. (2018)
processed <- process_spectra(spectra_list)
# Overview of the list architecture that is returned
#  with the list of processed spectra, peaks identified and the
#  metadata table
str(processed, max.level = 2)
# A detailed view of the metadata with the median signal-to-noise
#  ratio (SNR) and the number of peaks
processed$metadata
}
\references{
Strejcek M, Smrhova T, Junkova P & Uhlik O (2018). “Whole-Cell MALDI-TOF MS versus 16S rRNA Gene Analysis for Identification and Dereplication of Recurrent Bacterial Isolates.” \emph{Frontiers in Microbiology} 9 \url{doi:10.3389/fmicb.2018.01294}.
}
\seealso{
\link{import_biotyper_spectra} and \link{check_spectra} for the inputs and \link{merge_processed_spectra} for further analysis.
}
