% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp-get-railway.R, R/esp-get-stations.R
\encoding{UTF-8}
\name{esp_get_railway}
\alias{esp_get_railway}
\alias{esp_get_stations}
\title{Railways of Spain - SIANE}
\source{
CartoBase ANE provided by Instituto Geografico Nacional (IGN),
\url{http://www.ign.es/web/ign/portal}. Years available are 2005 up to today.

Copyright:
\url{https://centrodedescargas.cnig.es/CentroDescargas/cartobase-ane}

It's necessary to always acknowledge authorship using the following formulas:
\enumerate{
\item When the original digital product is not modified or altered, it can
be expressed in one of the following ways:
\itemize{
\item CartoBase ANE 2006-2024 CC-BY 4.0 ign.es
\item CartoBase ANE 2006-2024 CC-BY 4.0 Instituto Geográfico Nacional
}
\item When a new product is generated:
}
\itemize{
\item Obra derivada de CartoBase ANE 2006-2024 CC-BY 4.0 ign.es
}

Data distributed via a custom CDN, see
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata}.
}
\usage{
esp_get_railway(
  year = Sys.Date(),
  epsg = 4258,
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  spatialtype = c("line", "point")
)

esp_get_stations(
  year = Sys.Date(),
  epsg = 4258,
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{year}{Ignored.}

\item{epsg}{character string or number. Projection of the map: 4-digit
\href{https://epsg.io/}{EPSG code}. One of:
\itemize{
\item \code{"4258"}: \href{https://epsg.io/4258}{ETRS89}
\item \code{"4326"}: \href{https://epsg.io/4326}{WGS84}.
\item \code{"3035"}: \href{https://epsg.io/3035}{ETRS89 / ETRS-LAEA}.
\item \code{"3857"}: \href{https://epsg.io/3857}{Pseudo-Mercator}.
}}

\item{cache}{logical. Whether to do caching. Default is \code{TRUE}. See
\strong{Caching strategies} section in \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.}

\item{update_cache}{logical. Should the cached file be refreshed? Default
is \code{FALSE}. When set to \code{TRUE}, it will force a new download.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{spatialtype}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} character string.
Use \code{\link[=esp_get_stations]{esp_get_stations()}} instead of \code{"point"} for stations.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
Loads a \code{\link[sf:sf]{sf}} \code{LINESTRING} or \code{POINT} object representing the
nodes and railway lines of Spain.
}
\examples{
\dontshow{if (esp_check_access()) withAutoprint(\{ # examplesIf}
\donttest{
provs <- esp_get_prov()
ccaa <- esp_get_ccaa()

# Railways
rails <- esp_get_railway()

# Stations
stations <- esp_get_stations()

# Map

library(ggplot2)

ggplot(provs) +
  geom_sf(fill = "grey99", color = "grey50") +
  geom_sf(data = ccaa, fill = NA) +
  geom_sf(
    data = rails, aes(color = t_ffcc_desc),
    show.legend = FALSE,
    linewidth = 1.5
  ) +
  geom_sf(
    data = stations,
    color = "red", alpha = 0.5
  ) +
  scale_colour_viridis_d() +
  facet_wrap(~t_ffcc_desc) +
  theme_minimal()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other man-made infrastructures:
\code{\link{esp_get_roads}()}
}
\concept{infrastructure}
