% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{esp_nuts_2024}
\alias{esp_nuts_2024}
\title{NUTS 2024 for Spain \code{\link[sf:sf]{sf}} object}
\format{
An \code{\link[sf:sf]{sf}} object with \code{MULTIPOLYGON} geometries at 1:1 million
resolution in \href{https://epsg.io/4258}{EPSG:4258} projection, containing
86 rows and 10 variables:
\describe{
\item{\code{NUTS_ID}}{NUTS identifier.}
\item{\code{LEVL_CODE}}{NUTS level code \verb{(0,1,2,3)}.}
\item{\code{CNTR_CODE}}{Eurostat Country code.}
\item{\code{NAME_LATN}}{NUTS name on Latin characters.}
\item{\code{NUTS_NAME}}{NUTS name on local alphabet.}
\item{\code{MOUNT_TYPE}}{Mount Type, see \strong{Details}.}
\item{\code{URBN_TYPE}}{Urban Type, see \strong{Details}.}
\item{\code{COAST_TYPE}}{Coast Type, see \strong{Details}.}
\item{\code{geo}}{Same as \code{NUTS_ID}, provided for compatibility with
\CRANpkg{eurostat}.}
\item{\code{geometry}}{geometry field.}
}
}
\source{
\href{https://gisco-services.ec.europa.eu/distribution/v2/nuts/gpkg/}{NUTS_RG_01M_2024_4326.gpkg} file.
}
\description{
This dataset represents Spanish regions at NUTS levels 0, 1, 2, and 3
according to the Nomenclature of Territorial Units for Statistics (NUTS)
classification for 2024.
}
\details{
\code{MOUNT_TYPE}: Mountain typology:
\itemize{
\item \code{1}: More than 50\% of the surface is covered by topographic mountain
areas.
\item \code{2}: More than 50\% of the regional population lives in topographic
mountain areas.
\item \code{3}: More than 50\% of the surface is covered by topographic mountain
areas and more than 50\% of the regional population lives in these mountain
areas.
\item \code{4}: Non-mountain region or other regions.
\item \code{0}: No classification provided.
}

\code{URBN_TYPE}: Urban-rural typology:
\itemize{
\item \code{1}: Predominantly urban region.
\item \code{2}: Intermediate region.
\item \code{3}: Predominantly rural region.
\item \code{0}: No classification provided.
}

\code{COAST_TYPE}: Coastal typology:
\itemize{
\item \code{1}: Coastal region (on the coast).
\item \code{2}: Coastal region (less than 50\% of the population living within 50 km
of the coastline).
\item \code{3}: Non-coastal region.
\item \code{0}: No classification provided.
}
}
\examples{
data("esp_nuts_2024")
head(esp_nuts_2024)

}
\seealso{
\code{\link[=esp_get_nuts]{esp_get_nuts()}}

Other datasets: 
\code{\link{esp_codelist}},
\code{\link{esp_tiles_providers}},
\code{\link{pobmun25}}
}
\concept{datasets}
