% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{mapboxGeocoderInput}
\alias{mapboxGeocoderInput}
\title{Use Mapbox's Geocoder widget in a Shiny application}
\usage{
mapboxGeocoderInput(
  inputId,
  access_token = NULL,
  placeholder = "Search",
  search_within = NULL,
  proximity = NULL,
  limit = 5,
  min_length = 2,
  language = NULL
)
}
\arguments{
\item{inputId}{The Shiny input ID}

\item{access_token}{The Mapbox access token (required); can be set with
\code{\link[=mb_access_token]{mb_access_token()}}}

\item{placeholder}{The placeholder to be used in the search box; defaults to 'Search'}

\item{search_within}{An \code{sf} object, or vector representing a bounding box of
format \code{c(min_longitude, min_latitude, max_longitude, max_latitude)} used
to limit search results. Defaults to NULL.}

\item{proximity}{A length-2 vector of longitude and latitude coordinates used to prioritize results near to that location.  Defaults to NULL.}

\item{limit}{The maximum number of results to show.  Defaults to 5.}

\item{min_length}{The minimum number of characters the user must enter before results are shown.  Defaults to 2.}

\item{language}{The language to use for the geocoder.  Per the Mapbox documentation, "Options are IETF language tags comprised of a mandatory ISO 639-1 language code and optionally one or more IETF subtags for country or script."}
}
\value{
A Mapbox geocoder widget as a Shiny input
}
\description{
Use Mapbox's Geocoder widget in a Shiny application
}
